/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Properties;
import adams.core.net.Email;
import adams.core.option.OptionUtils;
import adams.data.io.output.AbstractEmailFileWriter;

public class PropertiesEmailFileWriter
extends AbstractEmailFileWriter {
    private static final long serialVersionUID = 8613890718581689507L;

    public String globalInfo() {
        return "Writes emails to properties files.";
    }

    @Override
    public String getFormatDescription() {
        return "Email properties files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"props", "properties"};
    }

    protected String toBlankSeparated(Object[] obj) {
        String[] list = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            list[i] = obj[i].toString();
        }
        String result = OptionUtils.joinOptions((String[])list);
        return result;
    }

    @Override
    protected String doWrite(Email email) {
        String result = null;
        Properties props = new Properties();
        props.setProperty("From", email.getFrom().getValue());
        props.setProperty("To", this.toBlankSeparated((Object[])email.getTo()));
        props.setProperty("CC", this.toBlankSeparated((Object[])email.getCC()));
        props.setProperty("BCC", this.toBlankSeparated((Object[])email.getBCC()));
        props.setProperty("Subject", email.getSubject());
        props.setProperty("Body", email.getBody());
        props.setProperty("Attachments", this.toBlankSeparated(email.getAttachments()));
        if (!props.save(this.m_Output.getAbsolutePath())) {
            result = "Failed to write properties to " + this.m_Output + ", check console!";
        }
        return result;
    }
}

