/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.SMTPConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

public class SendEmail
extends AbstractSink {
    private static final long serialVersionUID = -5959868605503747649L;
    protected AbstractSendEmail m_SendEmail;
    protected boolean m_Queue;
    protected List<SwingWorker> m_Sending;

    public String globalInfo() {
        return "Actor for sending emails.\n" + (EmailHelper.isEnabled() ? "" : "Email support not enabled, check email setup!");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("send-email", "sendEmail", (Object)EmailHelper.getDefaultSendEmail());
        this.m_OptionManager.add("queue", "queue", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Sending = new ArrayList<SwingWorker>();
    }

    public String getQuickInfo() {
        if (!EmailHelper.isEnabled()) {
            return "No email support enabled, check email setup!";
        }
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"sendEmail", ((Object)((Object)this.m_SendEmail)).getClass(), (String)"send: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (boolean)this.m_Queue, (String)"queue", (String)",");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setSendEmail(AbstractSendEmail value) {
        this.m_SendEmail = value;
        this.reset();
    }

    public AbstractSendEmail getSendEmail() {
        return this.m_SendEmail;
    }

    public String sendEmailTipText() {
        return "The engine for sending the emails.";
    }

    public void setQueue(boolean value) {
        this.m_Queue = value;
        this.reset();
    }

    public boolean getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "Whether to queue the emails rather than waiting for them to be sent.";
    }

    public Class[] accepts() {
        return new Class[]{Email.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !EmailHelper.isEnabled()) {
            result = "No email support enabled, check email setup!";
        }
        return result;
    }

    protected void initSession() throws Exception {
        if (this.m_SendEmail.requiresSmtpSessionInitialization()) {
            SMTPConnection conn = (SMTPConnection)ActorUtils.findClosestType((Actor)this, SMTPConnection.class, (boolean)true);
            if (conn != null) {
                conn.initializeSmtpSession(this.m_SendEmail);
            } else {
                this.m_SendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword());
            }
        }
    }

    protected String doExecute() {
        String result = null;
        final Email email = (Email)((Object)this.m_InputToken.getPayload());
        if (this.isLoggingEnabled()) {
            this.getLogger().info(email.toString());
        }
        if (this.m_Queue) {
            SwingWorker run = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    try {
                        SendEmail.this.initSession();
                        if (!SendEmail.this.m_SendEmail.sendMail(email)) {
                            SendEmail.this.m_Self.handleError(SendEmail.this.m_Self, "email", "Failed to send email, check console output!");
                        }
                    }
                    catch (Exception e) {
                        LoggingHelper.handleException((LoggingSupporter)SendEmail.this.m_Self, (String)"Failed to send email: ", (Throwable)e);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    SendEmail.this.m_Sending.remove(this);
                    super.done();
                }
            };
            this.m_Sending.add(run);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Queuing email, queue size: " + this.m_Sending.size());
            }
            run.execute();
        } else {
            try {
                this.initSession();
                if (!this.m_SendEmail.sendMail(email)) {
                    result = "Failed to send email, check console output!";
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to send email: ", e);
            }
        }
        return result;
    }

    public void stopExecution() {
        this.m_Sending.clear();
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        while (this.m_Sending.size() > 0 && !this.isStopped()) {
            try {
                SendEmail sendEmail = this;
                synchronized (sendEmail) {
                    ((Object)((Object)this)).wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
        this.m_SendEmail.cleanUp();
        super.wrapUp();
    }
}

