/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import adams.flow.sink.AbstractSink;
import adams.flow.websocket.client.SimpleSendGenerator;
import adams.flow.websocket.client.WebSocketClientGenerator;
import java.util.logging.Level;

public class WebSocketClient
extends AbstractSink {
    private static final long serialVersionUID = -8723835373836608550L;
    protected WebSocketClientGenerator m_Generator;
    protected transient com.pusher.java_websocket.client.WebSocketClient m_Client;
    protected boolean m_Disconnect;

    public String globalInfo() {
        return "Sends the incoming data to a websocket server and forwards the received data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new SimpleSendGenerator());
        this.m_OptionManager.add("disconnect", "disconnect", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Client = null;
    }

    public void setGenerator(WebSocketClientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public WebSocketClientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The client generator to use.";
    }

    public void setDisconnect(boolean value) {
        this.m_Disconnect = value;
        this.reset();
    }

    public boolean getDisconnect() {
        return this.m_Disconnect;
    }

    public String disconnectTipText() {
        return "If enabled, the connection will get closed immediately after sending the data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator);
    }

    public Class[] accepts() {
        return new Class[]{String.class, byte[].class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Client == null) {
            try {
                this.m_Client = this.m_Generator.generateClient();
                if (this.m_Client instanceof FlowContextHandler) {
                    ((FlowContextHandler)this.m_Client).setFlowContext((Actor)this);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to generate websocket client!", e);
            }
        }
        if (result == null) {
            try {
                if (!this.m_Client.connectBlocking()) {
                    result = "Failed to establish connection!";
                } else {
                    if (this.m_InputToken.getPayload() instanceof String) {
                        this.m_Client.send((String)this.m_InputToken.getPayload());
                    } else {
                        this.m_Client.send((byte[])this.m_InputToken.getPayload());
                    }
                    if (this.m_Disconnect) {
                        try {
                            this.m_Client.closeBlocking();
                        }
                        catch (Exception e) {
                            this.getLogger().log(Level.SEVERE, "Error closing websocket client!", (Throwable)e);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                result = this.handleException("Failed to connect/send data!", e);
            }
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_Client != null && this.m_Client.isOpen()) {
            try {
                this.m_Client.closeBlocking();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error closing websocket client!", (Throwable)e);
            }
            this.m_Client = null;
        }
        super.wrapUp();
    }
}

