/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.io.lister.SmbDirectoryLister;
import adams.core.logging.LoggingLevel;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.source.filesystemsearch.AbstractFileSystemSearchlet;
import adams.flow.standalone.SMBConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSmbDirectoryListerBasedSearchlet
extends AbstractFileSystemSearchlet {
    private static final long serialVersionUID = -240436041323613527L;
    protected SmbDirectoryLister m_Lister;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Lister = new SmbDirectoryLister();
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Lister.setLoggingLevel(value);
    }

    public void setHost(String value) {
        this.m_Lister.setHost(value);
    }

    public String getHost() {
        return this.m_Lister.getHost();
    }

    public String hostTipText() {
        return "The host to connect to.";
    }

    protected void check() throws Exception {
        super.check();
        if (this.m_FlowContext == null) {
            throw new IllegalStateException("No flow context provided, cannot obtain " + SMBConnection.class.getName() + "!");
        }
        SMBConnection conn = (SMBConnection)ActorUtils.findClosestType((Actor)this.m_FlowContext, SMBConnection.class);
        if (conn == null) {
            throw new IllegalStateException("No " + SMBConnection.class.getName() + " actor found!");
        }
        this.m_Lister.setAuthenticationProvider(conn);
    }

    protected List<String> doSearch() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(this.m_Lister.list()));
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
        this.m_Lister.stopExecution();
    }
}

