/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.lister.Sorting;
import adams.core.option.OptionHandler;
import adams.flow.source.filesystemsearch.AbstractFtpDirectoryListerBasedSearchlet;
import java.util.ArrayList;

public class FtpDirectorySearch
extends AbstractFtpDirectoryListerBasedSearchlet {
    private static final long serialVersionUID = 3229293554987103145L;

    public String globalInfo() {
        return "Searches only for directories (FTP).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", (Object)"/pub");
        this.m_OptionManager.add("max-items", "maxItems", (Object)-1);
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("sorting", "sorting", (Object)Sorting.NO_SORTING);
        this.m_OptionManager.add("descending", "sortDescending", (Object)false);
        this.m_OptionManager.add("recursive", "recursive", (Object)false);
        this.m_OptionManager.add("max-depth", "maxDepth", (Object)-1);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister.setListDirs(true);
        this.m_Lister.setListFiles(false);
    }

    public void setDirectory(String value) {
        this.m_Lister.setWatchDir(value);
    }

    public String getDirectory() {
        return this.m_Lister.getWatchDir();
    }

    public String directoryTipText() {
        return "The directory to search for directories.";
    }

    public void setMaxItems(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxItems() {
        return this.m_Lister.getMaxItems();
    }

    public String maxItemsTipText() {
        return "The maximum number of dirs to return (<= 0 is unlimited).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the dirs must match (empty string matches all).";
    }

    public void setSorting(Sorting value) {
        this.m_Lister.setSorting(value);
        this.reset();
    }

    public Sorting getSorting() {
        return this.m_Lister.getSorting();
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_Lister.setSortDescending(value);
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Lister.getSortDescending();
    }

    public String sortDescendingTipText() {
        return "If set to true, the directories are sorted in descending manner.";
    }

    public void setRecursive(boolean value) {
        this.m_Lister.setRecursive(value);
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Lister.getRecursive();
    }

    public String recursiveTipText() {
        return "Whether to search recursively or not.";
    }

    public void setMaxDepth(int value) {
        this.m_Lister.setMaxDepth(value);
        this.reset();
    }

    public int getMaxDepth() {
        return this.m_Lister.getMaxDepth();
    }

    public String maxDepthTipText() {
        return "The maximum depth to search in recursive mode (1 = only search directory, -1 = infinite).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"directory", (Object)this.getDirectory());
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"sorting", (Object)this.getSorting()));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"sortDescending", (this.getSorting() != Sorting.NO_SORTING && this.getSortDescending() ? 1 : 0) != 0, (String)"descending"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"recursive", (boolean)this.getRecursive(), (String)"recursive"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"maxItems", (Object)(this.getMaxItems() > 0 ? Integer.valueOf(this.getMaxItems()) : null), (String)"max="));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }
}

