/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.PasswordSupporter;
import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.net.SMBAuthenticationProvider;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import jcifs.smb.NtlmPasswordAuthentication;

public class SMBConnection
extends AbstractStandalone
implements OptionalPasswordPrompt,
SMBAuthenticationProvider,
PasswordSupporter {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_Domain;
    protected String m_User;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;
    protected transient NtlmPasswordAuthentication m_Session;

    public String globalInfo() {
        return "Provides access to a remote host via SMB.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("domain", "domain", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)System.getProperty("user.name"), false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"domain", (Object)(this.m_Domain.length() == 0 ? "no domain" : this.m_Domain), (String)"domain: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)this.m_User, (String)", user: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"password", (Object)this.m_Password.getValue().replaceAll(".", "*"));
        if (value != null) {
            result = result + ", pw: " + value;
        }
        ArrayList options = new ArrayList();
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
        }
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setDomain(String value) {
        this.m_Domain = value;
        this.reset();
    }

    public String getDomain() {
        return this.m_Domain;
    }

    public String domainTipText() {
        return "The domain name to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The SMB user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the SMB user to use for connecting.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassword = password;
        }
        return result;
    }

    @Override
    public synchronized NtlmPasswordAuthentication getAuthentication() {
        if (this.m_Session == null) {
            this.m_Session = this.newAuthentication();
        }
        return this.m_Session;
    }

    @Override
    public NtlmPasswordAuthentication newAuthentication() {
        return new NtlmPasswordAuthentication(this.m_Domain, this.m_User, this.m_ActualPassword.getValue());
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Session == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Starting new session");
            }
            this.m_ActualPassword = this.m_Password;
            if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
                if (!this.isHeadless()) {
                    if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                        } else {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        result = this.getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            }
            if (result == null) {
                this.m_Session = this.newAuthentication();
            }
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("Re-using current session");
        }
        return result;
    }
}

