/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.container.HttpRequestResult;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.form.FormData;
import com.github.fracpete.requests4j.request.Request;
import com.github.fracpete.requests4j.response.BasicResponse;
import java.io.File;
import java.net.URL;

public class HttpPostFile
extends AbstractTransformer {
    private static final long serialVersionUID = 7953283270649274835L;
    protected BaseURL m_URL;
    protected BaseKeyValuePair[] m_FormFields;
    protected String m_FormFieldFile;

    public String globalInfo() {
        return "Uploads the incoming file via HTTP POST to the specified URL as 'multipart/form-data'.\nAdditional form fields can be supplied as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL());
        this.m_OptionManager.add("form-field", "formFields", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("form-field-file", "formFieldFile", (Object)"");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)this.m_URL, (String)"URL: ");
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL for the request.";
    }

    public void setFormFields(BaseKeyValuePair[] value) {
        this.m_FormFields = value;
        this.reset();
    }

    public BaseKeyValuePair[] getFormFields() {
        return this.m_FormFields;
    }

    public String formFieldsTipText() {
        return "The additional form fields to send.";
    }

    public void setFormFieldFile(String value) {
        this.m_FormFieldFile = value;
        this.reset();
    }

    public String getFormFieldFile() {
        return this.m_FormFieldFile;
    }

    public String formFieldFileTipText() {
        return "The name of the form field for the file to upload.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{HttpRequestResult.class};
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.hasPayload(File.class) ? new PlaceholderFile((File)this.m_InputToken.getPayload(File.class)) : new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        try {
            Request req = Requests.post((URL)this.m_URL.urlValue()).formData(new FormData().add(BaseKeyValuePair.toMap((BaseKeyValuePair[])this.m_FormFields)).addFile(this.m_FormFieldFile, file.getAbsolutePath()));
            BasicResponse res = req.execute();
            HttpRequestResult response = new HttpRequestResult(res.statusCode(), res.statusMessage(), res.text());
            this.m_OutputToken = new Token((Object)response);
        }
        catch (Exception e) {
            result = this.handleException("Failed to post file '" + file + "' to '" + this.m_URL + "'!", e);
        }
        return result;
    }
}

