/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.base.BaseText;
import adams.core.io.FileUtils;
import adams.core.net.EmailHelper;
import adams.env.Environment;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.chooser.BaseTextChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class EmailSetupPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -7937644706618374284L;
    protected ParameterPanel m_PanelParameters;
    protected BaseCheckBox m_CheckBoxEnabled;
    protected BaseTextField m_TextSmtpServer;
    protected JSpinner m_SpinnerSmtpPort;
    protected JSpinner m_SpinnerSmtpTimeout;
    protected BaseCheckBox m_CheckBoxSmtpRequiresAuthentication;
    protected BaseCheckBox m_CheckBoxSmtpStartTLS;
    protected BaseCheckBox m_CheckBoxSmtpUseSSL;
    protected BaseTextField m_TextSmtpUser;
    protected JPasswordField m_TextSmtpPassword;
    protected BaseCheckBox m_CheckBoxShowPassword;
    protected BaseTextField m_TextDefaultFromAddress;
    protected BaseTextChooserPanel m_TextDefaultSignature;
    protected BaseTextField m_TextSupportEmailAddress;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "Center");
        this.m_CheckBoxEnabled = new BaseCheckBox();
        this.m_CheckBoxEnabled.setSelected(EmailHelper.isEnabled());
        this.m_PanelParameters.addParameter("_Enabled", (Component)this.m_CheckBoxEnabled);
        this.m_TextSmtpServer = new BaseTextField(20);
        this.m_TextSmtpServer.setText(EmailHelper.getSmtpServer());
        this.m_PanelParameters.addParameter("SMTP _Server", (Component)this.m_TextSmtpServer);
        this.m_SpinnerSmtpPort = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerSmtpPort.getModel()).setMinimum(Integer.valueOf(0));
        ((SpinnerNumberModel)this.m_SpinnerSmtpPort.getModel()).setMaximum(Integer.valueOf(65530));
        ((SpinnerNumberModel)this.m_SpinnerSmtpPort.getModel()).setStepSize(1);
        this.m_SpinnerSmtpPort.setValue(EmailHelper.getSmtpPort());
        this.m_PanelParameters.addParameter("SMTP _Port", (Component)this.m_SpinnerSmtpPort);
        this.m_SpinnerSmtpTimeout = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerSmtpTimeout.getModel()).setMinimum(Integer.valueOf(0));
        ((SpinnerNumberModel)this.m_SpinnerSmtpTimeout.getModel()).setMaximum(Integer.valueOf(1000000));
        ((SpinnerNumberModel)this.m_SpinnerSmtpTimeout.getModel()).setStepSize(1000);
        this.m_SpinnerSmtpTimeout.setValue(EmailHelper.getSmtpTimeout());
        this.m_PanelParameters.addParameter("SMTP T_imeout (msec)", (Component)this.m_SpinnerSmtpTimeout);
        this.m_CheckBoxSmtpRequiresAuthentication = new BaseCheckBox();
        this.m_CheckBoxSmtpRequiresAuthentication.setSelected(EmailHelper.getSmtpRequiresAuthentication());
        this.m_PanelParameters.addParameter("_Authentication required", (Component)this.m_CheckBoxSmtpRequiresAuthentication);
        this.m_CheckBoxSmtpStartTLS = new BaseCheckBox();
        this.m_CheckBoxSmtpStartTLS.setSelected(EmailHelper.getSmtpStartTLS());
        this.m_PanelParameters.addParameter("Start _TLS", (Component)this.m_CheckBoxSmtpStartTLS);
        this.m_CheckBoxSmtpUseSSL = new BaseCheckBox();
        this.m_CheckBoxSmtpUseSSL.setSelected(EmailHelper.getSmtpUseSSL());
        this.m_PanelParameters.addParameter("Use SS_L", (Component)this.m_CheckBoxSmtpUseSSL);
        this.m_TextSmtpUser = new BaseTextField(20);
        this.m_TextSmtpUser.setText(EmailHelper.getSmtpUser());
        this.m_PanelParameters.addParameter("SMTP _User", (Component)this.m_TextSmtpUser);
        this.m_TextSmtpPassword = new JPasswordField(20);
        this.m_TextSmtpPassword.setText(EmailHelper.getSmtpPassword().getValue());
        this.m_TextSmtpPassword.setEchoChar('*');
        this.m_PanelParameters.addParameter("SMTP _Password", (Component)this.m_TextSmtpPassword);
        this.m_CheckBoxShowPassword = new BaseCheckBox();
        this.m_CheckBoxShowPassword.setSelected(false);
        this.m_CheckBoxShowPassword.addActionListener(e -> {
            if (this.m_CheckBoxShowPassword.isSelected()) {
                this.m_TextSmtpPassword.setEchoChar('\u0000');
            } else {
                this.m_TextSmtpPassword.setEchoChar('*');
            }
        });
        this.m_PanelParameters.addParameter("Sho_w Password", (Component)this.m_CheckBoxShowPassword);
        this.m_TextDefaultFromAddress = new BaseTextField(20);
        this.m_TextDefaultFromAddress.setText(EmailHelper.getDefaultFromAddress());
        this.m_PanelParameters.addParameter("Default FROM address", (Component)this.m_TextDefaultFromAddress);
        this.m_TextDefaultSignature = new BaseTextChooserPanel();
        this.m_TextDefaultSignature.setDialogTitle("Enter signature");
        this.m_TextDefaultSignature.setDialogSize(GUIHelper.getDefaultSmallDialogDimension());
        this.m_TextDefaultSignature.setTextColumns(16);
        this.m_TextDefaultSignature.setCurrent((Object)new BaseText(Utils.unbackQuoteChars((String)EmailHelper.getDefaultSignature())));
        this.m_PanelParameters.addParameter("Default signature", (Component)new BaseScrollPane((Component)this.m_TextDefaultSignature));
        this.m_TextSupportEmailAddress = new BaseTextField(20);
        this.m_TextSupportEmailAddress.setText(EmailHelper.getSupportEmail());
        this.m_PanelParameters.addParameter("Suport email address", (Component)this.m_TextSupportEmailAddress);
    }

    protected Properties toProperties() {
        Properties result = new Properties();
        result.setBoolean("Enabled", Boolean.valueOf(this.m_CheckBoxEnabled.isSelected()));
        result.setProperty("SmtpServer", this.m_TextSmtpServer.getText());
        result.setInteger("SmtpPort", Integer.valueOf(((Number)this.m_SpinnerSmtpPort.getValue()).intValue()));
        result.setInteger("SmtpTimeout", Integer.valueOf(((Number)this.m_SpinnerSmtpTimeout.getValue()).intValue()));
        result.setBoolean("SmtpRequiresAuthentication", Boolean.valueOf(this.m_CheckBoxSmtpRequiresAuthentication.isSelected()));
        result.setBoolean("SmtpStartTls", Boolean.valueOf(this.m_CheckBoxSmtpStartTLS.isSelected()));
        result.setBoolean("SmtpUseSsl", Boolean.valueOf(this.m_CheckBoxSmtpUseSSL.isSelected()));
        result.setProperty("SmtpUser", this.m_TextSmtpUser.getText());
        result.setPassword("SmtpPassword", new BasePassword(this.m_TextSmtpPassword.getText()));
        result.setProperty("DefaultAddressFrom", this.m_TextDefaultFromAddress.getText());
        result.setProperty("DefaultSignature", Utils.backQuoteChars((String)((BaseText)this.m_TextDefaultSignature.getCurrent()).getValue()));
        result.setProperty("SupportEmail", this.m_TextSupportEmailAddress.getText());
        return result;
    }

    public String getTitle() {
        return "Email";
    }

    public boolean requiresWrapper() {
        return true;
    }

    public String activate() {
        boolean result = EmailHelper.writeProperties(this.toProperties());
        if (result) {
            return null;
        }
        return "Failed to save email setup to Email.props!";
    }

    public boolean canReset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("email");
        return props != null && FileUtils.fileExists((String)props);
    }

    public String reset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("email");
        if (props != null && FileUtils.fileExists((String)props) && !FileUtils.delete((String)props)) {
            return "Failed to remove custom email properties: " + props;
        }
        return null;
    }
}

