/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.core.base.BaseHostname;
import adams.core.base.BaseObject;
import adams.core.io.FileUtils;
import adams.core.net.SMBHelper;
import adams.env.Environment;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.core.BaseObjectTextField;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;

public class SMBSetupPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -7937644706618374284L;
    protected ParameterPanel m_PanelParameters;
    protected BaseObjectTextField<BaseHostname> m_TextWinsHost;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "Center");
        this.m_TextWinsHost = new BaseObjectTextField((BaseObject)new BaseHostname(SMBHelper.getWinsHost()));
        this.m_PanelParameters.addParameter("_Wins host", this.m_TextWinsHost);
    }

    protected Properties toProperties() {
        Properties result = new Properties();
        result.setProperty("WinsHost", this.m_TextWinsHost.getText());
        return result;
    }

    public String getTitle() {
        return "SMB";
    }

    public boolean requiresWrapper() {
        return true;
    }

    public String activate() {
        boolean result = SMBHelper.writeProperties(this.toProperties());
        if (result) {
            return null;
        }
        return "Failed to save SMB setup to SMB.props!";
    }

    public boolean canReset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("smb");
        return props != null && FileUtils.fileExists((String)props);
    }

    public String reset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("smb");
        if (props != null && FileUtils.fileExists((String)props) && !FileUtils.delete((String)props)) {
            return "Failed to remove custom SMB properties: " + props;
        }
        return null;
    }
}

