/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.net.SSLHelper;
import adams.core.net.hostnameverifier.All;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;

public class SSLSetupPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -7937644706618374284L;
    protected ParameterPanel m_PanelParameters;
    protected GenericObjectEditorPanel m_GOEHostnameVerifier;
    protected GenericObjectEditorPanel m_GOETrustManager;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "Center");
        this.m_GOEHostnameVerifier = new GenericObjectEditorPanel(HostnameVerifier.class, (Object)new All(), true);
        this.m_GOEHostnameVerifier.setPrefix("Hostname _verifier");
        this.m_PanelParameters.addParameter((AbstractChooserPanel)this.m_GOEHostnameVerifier);
        this.m_GOETrustManager = new GenericObjectEditorPanel(X509TrustManager.class, (Object)new adams.core.net.trustmanager.All(), true);
        this.m_GOETrustManager.setPrefix("_Trust manager");
        this.m_PanelParameters.addParameter((AbstractChooserPanel)this.m_GOETrustManager);
    }

    protected Properties toProperties() {
        Properties result = new Properties();
        result.setProperty("HostnameVerifier", OptionUtils.getCommandLine((Object)this.m_GOEHostnameVerifier.getCurrent()));
        result.setProperty("TrustManager", OptionUtils.getCommandLine((Object)this.m_GOETrustManager.getCurrent()));
        return result;
    }

    public String getTitle() {
        return "SSL";
    }

    public boolean requiresWrapper() {
        return true;
    }

    public String activate() {
        boolean result = SSLHelper.writeProperties(this.toProperties());
        if (result) {
            return null;
        }
        return "Failed to save SSL setup to SSL.props!";
    }

    public boolean canReset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("ssl");
        return props != null && FileUtils.fileExists((String)props);
    }

    public String reset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("ssl");
        if (props != null && FileUtils.fileExists((String)props) && !FileUtils.delete((String)props)) {
            return "Failed to remove custom SSL properties: " + props;
        }
        return null;
    }
}

