/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.PasswordSupporter;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.gui.chooser.RemoteDirectorySetup;
import java.util.logging.Level;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpRemoteDirectorySetup
extends AbstractOptionHandler
implements RemoteDirectorySetup,
ProtocolCommandListener,
PasswordSupporter {
    private static final long serialVersionUID = -8429471751146663032L;
    protected String m_Host;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_UsePassiveMode;
    protected boolean m_UseBinaryMode;
    protected String m_RemoteDir;
    protected FTPClient m_Client;

    public String globalInfo() {
        return "For configuring access to a remote directory via FTP.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)"anonymous", false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("passive", "usePassiveMode", (Object)false);
        this.m_OptionManager.add("binary", "useBinaryMode", (Object)false);
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"");
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The FTP user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the FTP user to use for connecting.";
    }

    public void setUsePassiveMode(boolean value) {
        this.m_UsePassiveMode = value;
        this.reset();
    }

    public boolean getUsePassiveMode() {
        return this.m_UsePassiveMode;
    }

    public String usePassiveModeTipText() {
        return "If enabled, passive mode is used instead.";
    }

    public void setUseBinaryMode(boolean value) {
        this.m_UseBinaryMode = value;
        this.reset();
    }

    public boolean getUseBinaryMode() {
        return this.m_UseBinaryMode;
    }

    public String useBinaryModeTipText() {
        return "If enabled, binary mode is used instead of ASCII.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The SFTP directory to download the file from.";
    }

    public synchronized FTPClient getClient() {
        if (this.m_Client == null) {
            this.m_Client = this.newClient();
        }
        return this.m_Client;
    }

    public FTPClient newClient() {
        FTPClient result;
        try {
            result = new FTPClient();
            result.addProtocolCommandListener((ProtocolCommandListener)this);
            result.connect(this.m_Host);
            int reply = result.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.getLogger().severe("FTP server refused connection: " + reply);
            } else if (!result.login(this.m_User, this.m_Password.getValue())) {
                this.getLogger().severe("Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "'");
            } else {
                if (this.m_UsePassiveMode) {
                    result.enterLocalPassiveMode();
                }
                if (this.m_UseBinaryMode) {
                    result.setFileType(2);
                }
            }
        }
        catch (Exception e) {
            LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "': "), (Throwable)e);
            result = null;
        }
        return result;
    }

    public void cleanUp() {
        if (this.m_Client != null && this.m_Client.isConnected()) {
            try {
                this.m_Client.disconnect();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to disconnect from '" + this.m_Host + "':", (Throwable)e);
            }
            this.m_Client.removeProtocolCommandListener((ProtocolCommandListener)this);
        }
        this.m_Client = null;
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        }
    }

    public boolean requiresInitialization() {
        return true;
    }
}

