/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.fileoperations.FileOperations;
import adams.core.io.fileoperations.SftpFileOperations;
import adams.core.io.lister.DirectoryLister;
import adams.core.io.lister.SftpDirectoryLister;
import adams.core.net.SSHSessionProvider;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanelWithIOSupport;
import adams.gui.chooser.SftpRemoteDirectorySetup;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Dialog;

public class SftpDirectoryChooserPanel
extends AbstractChooserPanelWithIOSupport<SftpRemoteDirectorySetup> {
    private static final long serialVersionUID = 6235369491956122980L;
    protected SSHSessionProvider m_Provider;

    public SftpDirectoryChooserPanel() {
        this.setCurrent(new SftpRemoteDirectorySetup());
    }

    protected void initialize() {
        super.initialize();
        this.reset();
    }

    protected void reset() {
        this.m_Provider = null;
    }

    public boolean setCurrent(SftpRemoteDirectorySetup value) {
        boolean result = super.setCurrent((Object)value);
        if (result) {
            this.reset();
        }
        return result;
    }

    protected SftpRemoteDirectorySetup doChoose() {
        SftpRemoteDirectorySetup currentSetup = (SftpRemoteDirectorySetup)this.getCurrent();
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Remote directory");
        dialog.getGOEEditor().setClassType(SftpRemoteDirectorySetup.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(false);
        dialog.setCurrent((Object)currentSetup);
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)this)));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return null;
        }
        SftpRemoteDirectorySetup newSetup = (SftpRemoteDirectorySetup)dialog.getCurrent();
        if (!newSetup.toCommandLine().equals(currentSetup.toCommandLine())) {
            this.reset();
        }
        return newSetup;
    }

    protected String toString(SftpRemoteDirectorySetup value) {
        return value.toCommandLine();
    }

    protected SftpRemoteDirectorySetup fromString(String value) {
        try {
            return (SftpRemoteDirectorySetup)OptionUtils.forAnyCommandLine(SftpRemoteDirectorySetup.class, (String)value);
        }
        catch (Exception e) {
            return new SftpRemoteDirectorySetup();
        }
    }

    public void setCurrentDirectory(String value) {
        SftpRemoteDirectorySetup current = (SftpRemoteDirectorySetup)this.getCurrent();
        current.setRemoteDir(value);
        this.setCurrent(current);
    }

    public String getCurrentDirectory() {
        return ((SftpRemoteDirectorySetup)this.getCurrent()).getRemoteDir();
    }

    public String getChooserType() {
        return "SFTP";
    }

    protected synchronized SSHSessionProvider getProvider() {
        if (this.m_Provider == null || this.m_Provider.getSession() == null) {
            this.m_Provider = (SSHSessionProvider)this.getCurrent();
        }
        return this.m_Provider;
    }

    public DirectoryLister getDirectoryLister() {
        SftpDirectoryLister result = new SftpDirectoryLister();
        result.setSessionProvider(this.getProvider());
        result.setWatchDir(this.getCurrentDirectory());
        return result;
    }

    public FileOperations getFileOperations() {
        SftpFileOperations result = new SftpFileOperations();
        result.setProvider(this.getProvider());
        return result;
    }
}

