/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.DateUtils;
import adams.core.SystemInfo;
import adams.core.io.FileUtils;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingLevel;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractBasicMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class SendErrorReport
extends AbstractBasicMenuItemDefinition {
    private static final long serialVersionUID = 4542388996174240562L;

    public SendErrorReport() {
        this(null);
    }

    public SendErrorReport(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "email.png";
    }

    public boolean isAvailable() {
        return EmailHelper.isEnabled() && !EmailHelper.getSupportEmail().isEmpty() && !EmailHelper.getDefaultFromAddress().isEmpty();
    }

    public String getTitle() {
        return "Send error report...";
    }

    public void launch() {
        String comment = GUIHelper.showInputDialog(null, (String)"Please supply some additional information on error report");
        String console = ConsolePanel.getSingleton().getPanel(ConsolePanel.PanelType.ALL).getContent();
        SpreadSheet info = new SystemInfo().toSpreadSheet();
        ArrayList<File> atts = new ArrayList<File>();
        File prefix = TempUtils.createTempFile((String)"errorreport", null);
        File file = new File(prefix.getAbsolutePath() + ".txt");
        if (FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)console, (boolean)false)) {
            atts.add(file);
        } else {
            ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, "Failed to write console panel content for error report to: " + file);
        }
        file = new File(prefix.getAbsolutePath() + ".csv");
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        if (writer.write(info, file)) {
            atts.add(file);
        } else {
            ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, "Failed to write system info for error report to: " + file);
        }
        Email email = new Email(new EmailAddress(EmailHelper.getDefaultFromAddress()), new EmailAddress(EmailHelper.getSupportEmail()), Environment.getInstance().getProject() + " error report", "Error report generated at " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\nSee attachements for details" + (comment == null ? "" : "\nUser comment:\n" + comment), atts.toArray(new File[atts.size()]));
        AbstractSendEmail sendEmail = EmailHelper.getDefaultSendEmail();
        try {
            if (sendEmail.requiresSmtpSessionInitialization()) {
                sendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword());
            }
            sendEmail.sendMail(email);
            GUIHelper.showInformationMessage(null, (String)("Error report sent to " + EmailHelper.getSupportEmail()));
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(null, (String)"Failed to send error report email!", (Throwable)e);
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    public String getCategory() {
        return "Program";
    }
}

