/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.io.PlaceholderFile;
import adams.core.net.EmailHelper;
import adams.env.Environment;
import adams.gui.dialog.ComposeEmailDialog;
import adams.gui.sendto.AbstractSendToAction;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;

public class EmailRecipient
extends AbstractSendToAction {
    private static final long serialVersionUID = 5177606045614245912L;

    public String getAction() {
        return "Email recipient";
    }

    public String getIconName() {
        return "email.png";
    }

    public Class[] accepts() {
        if (EmailHelper.isEnabled()) {
            return new Class[]{File.class, File[].class, PlaceholderFile.class, PlaceholderFile[].class, String.class};
        }
        return new Class[0];
    }

    public String send(Object o) {
        int i;
        ComposeEmailDialog dialog = new ComposeEmailDialog((Frame)Environment.getInstance().getApplicationFrame());
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setCloseOnSend(true);
        PlaceholderFile[] files = new PlaceholderFile[]{};
        String body = "";
        if (o instanceof File) {
            files = new PlaceholderFile[]{new PlaceholderFile((File)o)};
        } else if (o instanceof File[]) {
            File[] tmpFiles = (File[])o;
            files = new PlaceholderFile[tmpFiles.length];
            for (i = 0; i < tmpFiles.length; ++i) {
                files[i] = new PlaceholderFile(tmpFiles[i]);
            }
        } else if (o instanceof PlaceholderFile) {
            files = new PlaceholderFile[]{(PlaceholderFile)o};
        } else if (o instanceof PlaceholderFile[]) {
            files = (PlaceholderFile[])o;
        } else if (o instanceof String) {
            body = (String)o;
        } else {
            throw new IllegalArgumentException("Unhandled class type: " + o.getClass());
        }
        StringBuilder subject = new StringBuilder();
        for (i = 0; i < files.length; ++i) {
            if (i > 0) {
                subject.append(", ");
            }
            subject.append(files[i].getName());
        }
        dialog.setAttachments(files);
        dialog.setSubject(subject.toString());
        dialog.setBody(body);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        String result = dialog.getLastSendResult();
        if (result == null && dialog.getDialogClosedByUser()) {
            result = "Email sending canceled by user!";
        }
        return result;
    }
}

