/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.fileoperations;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.fileoperations.AbstractRemoteFileOperations;
import adams.core.io.fileoperations.Operation;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.core.net.SMB;
import adams.core.net.SMBAuthenticationProvider;
import java.io.File;
import jcifs.smb.SmbFile;

public class SmbFileOperations
extends AbstractRemoteFileOperations {
    private static final long serialVersionUID = -4668267794023495691L;
    protected SMBAuthenticationProvider m_Provider;

    public void setProvider(SMBAuthenticationProvider value) {
        this.m_Provider = value;
    }

    public SMBAuthenticationProvider getProvider() {
        return this.m_Provider;
    }

    public boolean isSupported(Operation op) {
        switch (op) {
            case COPY: 
            case MOVE: 
            case RENAME: 
            case DELETE: 
            case MKDIR: {
                return true;
            }
        }
        throw new IllegalStateException("Unhandled operation: " + op);
    }

    public String copy(String source, String target) {
        String result;
        switch (this.m_Direction) {
            case LOCAL_TO_REMOTE: {
                result = SMB.copyTo((LoggingObject)this, this.m_Provider, (File)new PlaceholderFile(source), target);
                break;
            }
            case REMOTE_TO_LOCAL: {
                result = SMB.copyFrom((LoggingObject)this, this.m_Provider, source, (File)new PlaceholderFile(target));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled direction: " + this.m_Direction);
            }
        }
        return result;
    }

    public String move(String source, String target) {
        Object result = this.copy(source, target);
        if (result == null) {
            switch (this.m_Direction) {
                case LOCAL_TO_REMOTE: {
                    if (FileUtils.delete((String)source)) break;
                    result = "Failed to delete: " + source;
                    break;
                }
                case REMOTE_TO_LOCAL: {
                    result = this.delete(source);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled direction: " + this.m_Direction);
                }
            }
        }
        return result;
    }

    protected String renameRemote(String source, String target) {
        try {
            SmbFile file = new SmbFile(source, this.m_Provider.getAuthentication());
            file.renameTo(new SmbFile(target, this.m_Provider.getAuthentication()));
        }
        catch (Exception e) {
            return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to rename file: " + source + " -> " + target), (Throwable)e);
        }
        return null;
    }

    protected String deleteRemote(String file) {
        try {
            SmbFile smbfile = new SmbFile(file, this.m_Provider.getAuthentication());
            smbfile.delete();
        }
        catch (Exception e) {
            return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to delete file: " + file), (Throwable)e);
        }
        return null;
    }

    protected String mkdirRemote(String dir) {
        try {
            SmbFile smbfile = new SmbFile(dir, this.m_Provider.getAuthentication());
            smbfile.mkdirs();
        }
        catch (Exception e) {
            return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to create directory: " + dir), (Throwable)e);
        }
        return null;
    }
}

