/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.DeprecatedClass;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BasePassword;
import adams.core.io.FileUtils;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.HttpRequestHelper;
import adams.core.net.InternetHelper;
import adams.core.net.MimeTypeHelper;
import adams.core.net.SimpleApacheSendEmail;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SMTPSClient;
import org.apache.commons.net.smtp.SimpleSMTPHeader;
import org.apache.tika.mime.MediaType;

@DeprecatedClass(useInstead={SimpleApacheSendEmail.class})
@MixedCopyright(copyright="Apache Software Foundation", license=License.APACHE2, url="http://commons.apache.org/proper/commons-net/examples/mail/SMTPMail.java", note="Code adapted from SMTPMail")
public class ApacheSendEmail
extends AbstractSendEmail {
    private static final long serialVersionUID = 4065886204614191616L;
    protected transient SMTPClient m_Client;
    protected String m_Server;
    protected int m_Port;
    protected boolean m_UseTLS;
    protected String m_Protocols;
    protected boolean m_UseSSL;
    protected int m_Timeout;
    protected boolean m_RequiresAuth;
    protected String m_User;
    protected BasePassword m_Password;

    public String globalInfo() {
        return "Uses the Apache SMTPClient/SMTPSClient to send emails.";
    }

    @Override
    public boolean requiresSmtpSessionInitialization() {
        return this.m_Client == null;
    }

    @Override
    public void initializeSmtpSession(String server, int port, boolean useTLS, boolean useSSL, int timeout, boolean requiresAuth, String user, BasePassword pw, String protocols) throws Exception {
        this.m_Server = server;
        this.m_Port = port;
        this.m_UseTLS = useTLS;
        this.m_Protocols = protocols;
        this.m_UseSSL = useSSL;
        this.m_Timeout = timeout;
        this.m_RequiresAuth = requiresAuth;
        this.m_User = user;
        this.m_Password = pw;
        if (this.m_UseTLS) {
            this.m_Client = this.m_RequiresAuth ? new AuthenticatingSMTPClient() : new SMTPSClient();
            if (!this.m_Protocols.isEmpty()) {
                ((SMTPSClient)this.m_Client).setEnabledProtocols(this.m_Protocols.split(","));
            }
        } else {
            this.m_Client = new SMTPClient();
        }
        this.m_Client.setConnectTimeout(this.m_Timeout);
        if (this.isLoggingEnabled()) {
            this.m_Client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), true));
        }
    }

    @Override
    public boolean sendMail(Email email) throws Exception {
        int i;
        if (this.m_Client == null) {
            throw new IllegalStateException("SMTP session not initialized!");
        }
        SimpleSMTPHeader header = new SimpleSMTPHeader(email.getFrom().getValue(), Utils.flatten((Object[])email.getTo(), (String)", "), email.getSubject());
        for (i = 0; i < email.getCC().length; ++i) {
            header.addCC(email.getCC()[i].getValue());
        }
        String boundary = HttpRequestHelper.createBoundary();
        header.addHeaderField("Content-Type", "multipart/mixed; boundary=" + boundary);
        this.m_Client.connect(this.m_Server, this.m_Port);
        if (!SMTPReply.isPositiveCompletion((int)this.m_Client.getReplyCode())) {
            this.m_Client.disconnect();
            this.getLogger().severe("SMTP server " + this.m_Server + ":" + this.m_Port + " refused connection: " + this.m_Client.getReplyCode());
            return false;
        }
        if (!this.m_Client.login()) {
            this.m_Client.disconnect();
            this.getLogger().severe("Failed to login to SMTP server " + this.m_Server + ":" + this.m_Port + "!");
            return false;
        }
        if (this.m_UseTLS && !((SMTPSClient)this.m_Client).execTLS()) {
            this.m_Client.logout();
            this.m_Client.disconnect();
            this.getLogger().severe("SMTP server " + this.m_Server + ":" + this.m_Port + " failed to start TLS!");
            return false;
        }
        if (this.m_RequiresAuth && !((AuthenticatingSMTPClient)this.m_Client).auth(AuthenticatingSMTPClient.AUTH_METHOD.PLAIN, this.m_User, this.m_Password.getValue())) {
            this.m_Client.logout();
            this.m_Client.disconnect();
            this.getLogger().severe("Failed to authenticate: user=" + this.m_User + ", pw=" + this.m_Password.getMaskedValue());
            return false;
        }
        this.m_Client.setSender(email.getFrom().stringValue());
        for (i = 0; i < email.getTo().length; ++i) {
            this.m_Client.addRecipient(email.getTo()[i].getValue());
        }
        for (i = 0; i < email.getCC().length; ++i) {
            this.m_Client.addRecipient(email.getCC()[i].strippedValue());
        }
        for (i = 0; i < email.getBCC().length; ++i) {
            this.m_Client.addRecipient(email.getBCC()[i].stringValue());
        }
        Writer writer = this.m_Client.sendMessageData();
        if (writer == null) {
            this.m_Client.logout();
            this.m_Client.disconnect();
            this.getLogger().severe("Cannot send data!");
            return false;
        }
        writer.write(header.toString());
        writer.write("--" + boundary + "\n");
        writer.write("Content-Type: text/plain; charset=ISO-8859-1\n");
        writer.write("\n");
        writer.write(email.getBody());
        writer.write("\n");
        writer.write("\n");
        if (email.getAttachments().length > 0) {
            for (File file : email.getAttachments()) {
                String[] lines;
                writer.write("--" + boundary + "\n");
                MediaType mime = MimeTypeHelper.getMimeType(file);
                writer.write("Content-Type: " + mime.toString() + "; name=\"" + file.getName() + "\"\n");
                writer.write("Content-Disposition: attachment; filename=\"" + file.getName() + "\"\n");
                writer.write("Content-Transfer-Encoding: base64\n");
                writer.write("\n");
                byte[] content = FileUtils.loadFromBinaryFile((File)file);
                for (String line : lines = HttpRequestHelper.breakUp(InternetHelper.encodeBase64((byte[])content), 76)) {
                    writer.write(line + "\n");
                }
            }
        }
        writer.write("--" + boundary + "--\n");
        writer.close();
        if (!this.m_Client.completePendingCommand()) {
            this.m_Client.logout();
            this.m_Client.disconnect();
            this.getLogger().severe("Failed to complete pending command!");
            return false;
        }
        this.m_Client.logout();
        this.m_Client.disconnect();
        return true;
    }
}

