/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;

public class MimeTypeHelper {
    public static final String MIMETYPE_APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String MIMETYPE_PLAIN_TEXT = "plain/text";

    public static MediaType getMimeType(File file) {
        return MimeTypeHelper.getMimeType(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaType getMimeType(String filename) {
        MediaType mediaType;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(filename);
            bis = new BufferedInputStream(fis);
            AutoDetectParser parser = new AutoDetectParser();
            Detector detector = parser.getDetector();
            Metadata md = new Metadata();
            md.add("resourceName", filename);
            MediaType result = detector.detect((InputStream)bis, md);
            bis.close();
            mediaType = result;
            FileUtils.closeQuietly((InputStream)bis);
        }
        catch (Exception e) {
            MediaType mediaType2 = MediaType.OCTET_STREAM;
            return mediaType2;
        }
        finally {
            FileUtils.closeQuietly(bis);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((InputStream)fis);
        return mediaType;
    }
}

