/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.net.Base64Type;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionFromString;
import java.util.Base64;

public class Base64ToByteArray
extends AbstractConversionFromString {
    private static final long serialVersionUID = 1383459505178870114L;
    protected Base64Type m_Type;

    public String globalInfo() {
        return "Decodes a base64 string into a byte array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Base64Type.AUTO);
    }

    public void setType(Base64Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Base64Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of conversion to use; " + Base64Type.AUTO + " attempts all of them.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public Class generates() {
        return byte[].class;
    }

    protected Object doConvert() throws Exception {
        switch (this.m_Type) {
            case AUTO: {
                try {
                    return Base64.getDecoder().decode((String)this.m_Input);
                }
                catch (Exception exception) {
                    try {
                        return Base64.getUrlDecoder().decode((String)this.m_Input);
                    }
                    catch (Exception exception2) {
                        try {
                            return Base64.getMimeDecoder().decode((String)this.m_Input);
                        }
                        catch (Exception exception3) {
                            throw new IllegalStateException("Failed to decode!");
                        }
                    }
                }
            }
            case BASIC: {
                return Base64.getDecoder().decode((String)this.m_Input);
            }
            case URL_FILENAME_SAFE: {
                return Base64.getUrlDecoder().decode((String)this.m_Input);
            }
            case MIME: {
                return Base64.getMimeDecoder().decode((String)this.m_Input);
            }
        }
        throw new IllegalStateException("Unhandled type: " + this.m_Type);
    }
}

