/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractStringConversion;
import java.net.URLDecoder;

public class URLDecode
extends AbstractStringConversion
implements EncodingSupporter {
    private static final long serialVersionUID = 8430779020000469313L;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "Decodes the URL encoded string back to a regular string (uses " + Utils.classToString(URLDecoder.class) + ").";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset("UTF-8"));
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for the decoding.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding);
    }

    protected Object doConvert() throws Exception {
        return URLDecoder.decode((String)this.m_Input, this.m_Encoding.stringValue());
    }
}

