/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import java.net.URLDecoder;
import java.util.ArrayList;

public class URLParametersToStringArray
extends AbstractConversion
implements EncodingSupporter {
    private static final long serialVersionUID = 8430779020000469313L;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "Turns URL parameters like '...?k1=v1&k2=v2' back into a string array (uses " + Utils.classToString(URLDecoder.class) + ").";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset("UTF-8"));
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for the decoding.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding);
    }

    public Class accepts() {
        return String.class;
    }

    public Class generates() {
        return String[].class;
    }

    protected Object doConvert() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String input = (String)this.m_Input;
        if (input.contains("?")) {
            input = input.substring(input.indexOf(63) + 1);
        }
        String[] parts = input.contains("&") ? input.split("&") : new String[]{input};
        for (int i = 0; i < parts.length; ++i) {
            result.add(URLDecoder.decode(parts[i], this.m_Encoding.stringValue()));
        }
        return result.toArray(new String[result.size()]);
    }
}

