/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.data.io.input.AbstractEmailFileReader;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import jodd.mail.EMLParser;
import jodd.mail.EmailMessage;
import jodd.mail.ReceivedEmail;

public class EmlEmailFileReader
extends AbstractEmailFileReader {
    private static final long serialVersionUID = -341050738394654936L;

    public String globalInfo() {
        return "Reads emails stored in EML files.";
    }

    @Override
    public String getFormatDescription() {
        return "EML files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"eml"};
    }

    protected String[] toString(jodd.mail.EmailAddress[] addresses) {
        String[] result = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            result[i] = addresses[i].getEmail();
        }
        return result;
    }

    @Override
    protected Email doRead() {
        Email result = null;
        try {
            ReceivedEmail email = new EMLParser().parse(this.m_Input.getAbsoluteFile());
            List msgs = email.messages();
            StringBuilder body = new StringBuilder();
            for (int i = 0; i < msgs.size(); ++i) {
                if (msgs.size() > 1) {
                    body.append("---Message #" + (i + 1) + " " + ((EmailMessage)msgs.get(i)).getMimeType() + " " + ((EmailMessage)msgs.get(i)).getEncoding() + "\n");
                }
                body.append(((EmailMessage)msgs.get(i)).getContent());
                body.append("\n");
            }
            result = new Email(new EmailAddress(email.from().getEmail()), (EmailAddress[])EmailAddress.toObjectArray((String[])this.toString(email.to()), EmailAddress.class), (EmailAddress[])EmailAddress.toObjectArray((String[])this.toString(email.cc()), EmailAddress.class), new EmailAddress[0], email.subject(), body.toString(), new File[0]);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read: " + this.m_Input, (Throwable)e);
        }
        return result;
    }
}

