/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class HttpRequestResult
extends AbstractContainer {
    private static final long serialVersionUID = -2153844706336105272L;
    public static final String VALUE_STATUSCODE = "Status code";
    public static final String VALUE_STATUSMESSAGE = "Status message";
    public static final String VALUE_BODY = "Body";
    public static final String VALUE_COOKIES = "Cookies";

    public HttpRequestResult() {
        this.store(VALUE_STATUSCODE, 200);
        this.store(VALUE_STATUSMESSAGE, "OK");
        this.store(VALUE_BODY, "");
    }

    public HttpRequestResult(int statusCode, String statusMessage, String body) {
        this(statusCode, statusMessage, body, null);
    }

    public HttpRequestResult(int statusCode, String statusMessage, String body, Map<String, String> cookies) {
        this();
        this.store(VALUE_STATUSCODE, statusCode);
        this.store(VALUE_STATUSMESSAGE, statusMessage);
        this.store(VALUE_BODY, body);
        this.store(VALUE_COOKIES, cookies);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_STATUSCODE, "HTTP status code", Integer.class);
        this.addHelp(VALUE_STATUSMESSAGE, "HTTP status message", String.class);
        this.addHelp(VALUE_BODY, "HTML of the request", String.class);
        this.addHelp(VALUE_COOKIES, "cookie mappings (String/String)", Map.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_STATUSCODE);
        result.add(VALUE_STATUSMESSAGE);
        result.add(VALUE_BODY);
        result.add(VALUE_COOKIES);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_STATUSCODE) && this.hasValue(VALUE_BODY);
    }
}

