/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.BufferSupporter;
import adams.core.ByteFormat;
import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;

public class DownloadFile
extends AbstractFileWriter
implements BufferSupporter {
    private static final long serialVersionUID = 8688918591152139449L;
    protected int m_BufferSize;

    public String globalInfo() {
        return "Downloads a file from a URL and saves it locally.\nAlso handles basic authentication when using URLs like this:\nhttp://user:pass@domain.com/url";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("buffer-size", "bufferSize", (Object)1024, (Number)1, null);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"bufferSize", (Object)this.m_BufferSize, (String)"Buffer: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)", Output: ");
        return result;
    }

    public void setBufferSize(int value) {
        if (this.getOptionManager().isValid("bufferSize", (Number)value)) {
            this.m_BufferSize = value;
            this.reset();
        }
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of byte-buffer used for reading/writing the content.";
    }

    public String outputFileTipText() {
        return "The file to save the downloaded content to.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, URL.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(author="http://stackoverflow.com/users/2920131/lboix", license=License.CC_BY_SA_3, url="http://stackoverflow.com/a/13122190", note="handling basic authentication")
    protected String doExecute() {
        String result;
        block9: {
            BufferedInputStream input = null;
            BufferedOutputStream output = null;
            FileOutputStream fos = null;
            try {
                int len;
                URL url = this.m_InputToken.getPayload() instanceof String ? new URL((String)this.m_InputToken.getPayload()) : (URL)this.m_InputToken.getPayload();
                URLConnection conn = url.openConnection();
                if (url.getUserInfo() != null) {
                    String basicAuth = "Basic " + new String(Base64.getEncoder().encode(url.getUserInfo().getBytes()));
                    conn.setRequestProperty("Authorization", basicAuth);
                }
                input = new BufferedInputStream(conn.getInputStream());
                fos = new FileOutputStream(this.m_OutputFile.getAbsoluteFile());
                output = new BufferedOutputStream(fos);
                byte[] buffer = new byte[this.m_BufferSize];
                int count = 0;
                long totalLen = 0L;
                while ((len = input.read(buffer)) > 0 && !this.isStopped()) {
                    output.write(buffer, 0, len);
                    totalLen += (long)len;
                    if (++count % 100 != 0) continue;
                    output.flush();
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("Downloaded: " + ByteFormat.toBestFitBytes((double)totalLen, (int)1));
                }
                output.flush();
                result = null;
                FileUtils.closeQuietly((InputStream)input);
            }
            catch (Exception e) {
                result = this.handleException("Problem downloading '" + this.m_InputToken.getPayload() + "': ", e);
                break block9;
            }
            finally {
                FileUtils.closeQuietly(input);
                FileUtils.closeQuietly(output);
                FileUtils.closeQuietly(fos);
            }
            FileUtils.closeQuietly((OutputStream)output);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        if (this.isStopped()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Removing incomplete file: " + this.m_OutputFile);
            }
            FileUtils.delete((File)this.m_OutputFile);
        }
        return result;
    }
}

