/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.base.BaseString;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BaseHtmlEditorPane;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;

public class Html4Display
extends AbstractGraphicalDisplay
implements TextSupplier {
    private static final long serialVersionUID = -9623335130679482L;
    protected BaseString[] m_CSS;
    protected transient BaseHtmlEditorPane m_EditorPane;

    public String globalInfo() {
        return "Viewer for HTML 4.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("css", "CSS", (Object)new BaseString[0]);
    }

    public void setCSS(BaseString[] value) {
        this.m_CSS = value;
        this.reset();
    }

    public BaseString[] getCSS() {
        return this.m_CSS;
    }

    public String CSSTipText() {
        return "The CSS style sheet rules to apply.";
    }

    protected BasePanel newPanel() {
        this.m_EditorPane = new BaseHtmlEditorPane();
        this.m_EditorPane.addDefaultHyperlinkListener();
        if (this.m_CSS.length > 0) {
            this.m_EditorPane.addCSS(this.m_CSS);
        }
        this.m_EditorPane.setEditable(false);
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        result.add((Component)new BaseScrollPane((Component)this.m_EditorPane), (Object)"Center");
        return result;
    }

    public void clearPanel() {
        if (this.m_EditorPane != null) {
            this.m_EditorPane.setDocument(this.m_EditorPane.getEditorKit().createDefaultDocument());
            this.m_EditorPane.setText("<html></html>");
        }
    }

    public boolean supportsClear() {
        return true;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    protected void display(Token token) {
        this.m_EditorPane.setDocument(this.m_EditorPane.getEditorKit().createDefaultDocument());
        this.m_EditorPane.setText((String)token.getPayload(String.class));
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save html as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("HTML files", "html");
    }

    public String supplyText() {
        if (this.m_Panel == null) {
            return null;
        }
        return this.m_EditorPane.getText();
    }
}

