/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sendnotification;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.AbstractSendEmail;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.sendnotification.AbstractNotification;
import adams.flow.standalone.SMTPConnection;

public class Email
extends AbstractNotification {
    private static final long serialVersionUID = 1302036525857934850L;
    protected EmailAddress m_Sender;
    protected EmailAddress[] m_Recipients;
    protected EmailAddress[] m_CC;
    protected EmailAddress[] m_BCC;
    protected String m_Subject;
    protected BaseText m_Signature;
    protected AbstractSendEmail m_SendEmail;

    public String globalInfo() {
        return "Uses the incoming message as body in the email being sent.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sender", "sender", (Object)new EmailAddress(EmailHelper.getDefaultFromAddress()), false);
        this.m_OptionManager.add("recipient", "recipients", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("cc", "CC", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("bcc", "BCC", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("subject", "subject", (Object)"");
        this.m_OptionManager.add("signature", "signature", (Object)new BaseText(Utils.unbackQuoteChars((String)EmailHelper.getDefaultSignature())));
        this.m_OptionManager.add("send-email", "sendEmail", (Object)EmailHelper.getDefaultSendEmail());
    }

    public String getQuickInfo() {
        if (!EmailHelper.isEnabled()) {
            return "No email support enabled, check email setup!";
        }
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"sender", (Object)((Object)this.m_Sender), (String)"From: ");
        String value = this.m_Recipients != null && this.m_Recipients.length > 0 ? Utils.flatten((Object[])this.m_Recipients, (String)", ") : "<no recipients>";
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"recipients", (Object)value, (String)", To: ");
        value = this.m_CC != null && this.m_CC.length > 0 ? Utils.flatten((Object[])this.m_CC, (String)", ") : null;
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"CC", (Object)value, (String)", CC: ")) != null) {
            result = (String)result + value;
        }
        value = this.m_BCC != null && this.m_BCC.length > 0 ? Utils.flatten((Object[])this.m_BCC, (String)", ") : null;
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"BCC", (Object)value, (String)", BCC: ")) != null) {
            result = (String)result + value;
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sendEmail", ((Object)((Object)this.m_SendEmail)).getClass(), (String)", send: ");
        return result;
    }

    public void setSender(EmailAddress value) {
        this.m_Sender = value;
        this.reset();
    }

    public EmailAddress getSender() {
        return this.m_Sender;
    }

    public String senderTipText() {
        return "The sender address to use.";
    }

    public void setRecipients(EmailAddress[] value) {
        this.m_Recipients = value;
        this.reset();
    }

    public EmailAddress[] getRecipients() {
        return this.m_Recipients;
    }

    public String recipientsTipText() {
        return "The recipients to send the email to.";
    }

    public void setCC(EmailAddress[] value) {
        this.m_CC = value;
        this.reset();
    }

    public EmailAddress[] getCC() {
        return this.m_CC;
    }

    public String CCTipText() {
        return "The CC recipients to send the email to.";
    }

    public void setBCC(EmailAddress[] value) {
        this.m_BCC = value;
        this.reset();
    }

    public EmailAddress[] getBCC() {
        return this.m_BCC;
    }

    public String BCCTipText() {
        return "The BCC recipients to send the email to.";
    }

    public void setSubject(String value) {
        this.m_Subject = value;
        this.reset();
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public String subjectTipText() {
        return "The subject of the email, can contain variables.";
    }

    public void setSignature(BaseText value) {
        this.m_Signature = value;
        this.reset();
    }

    public BaseText getSignature() {
        return this.m_Signature;
    }

    public String signatureTipText() {
        return "The signature of the email, gets separated by an extra line consisting of '--', can contain variables.";
    }

    public void setSendEmail(AbstractSendEmail value) {
        this.m_SendEmail = value;
        this.reset();
    }

    public AbstractSendEmail getSendEmail() {
        return this.m_SendEmail;
    }

    public String sendEmailTipText() {
        return "The engine for sending the emails.";
    }

    protected String check(String msg) {
        String result = super.check(msg);
        if (result == null && !EmailHelper.isEnabled()) {
            result = "No email support enabled, check email setup!";
        }
        return result;
    }

    protected void initSession() throws Exception {
        if (this.m_SendEmail.requiresSmtpSessionInitialization()) {
            SMTPConnection conn = (SMTPConnection)ActorUtils.findClosestType((Actor)this.m_FlowContext, SMTPConnection.class, (boolean)true);
            if (conn != null) {
                conn.initializeSmtpSession(this.m_SendEmail);
            } else {
                this.m_SendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword(), EmailHelper.getSmtpProtocols());
            }
        }
    }

    protected String doSendNotification(String msg) {
        String result = null;
        String subject = this.m_FlowContext.getVariables().expand(this.m_Subject);
        adams.core.net.Email email = null;
        try {
            email = new adams.core.net.Email(this.m_Sender, this.m_Recipients, this.m_CC, this.m_BCC, subject, msg, null);
            if (this.isLoggingEnabled()) {
                this.getLogger().info(email.toString());
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to generate email!", (Throwable)e);
        }
        if (result == null) {
            try {
                this.initSession();
                if (!this.m_SendEmail.sendMail(email)) {
                    result = "Failed to send email, check console output!";
                }
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to send email: ", (Throwable)e);
            }
        }
        return result;
    }
}

