/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.logging.LoggingSupporter;
import adams.core.net.PortManager;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class Socket
extends AbstractSimpleSource
implements EncodingSupporter,
ClassCrossReference {
    private static final long serialVersionUID = 4824594325548647716L;
    protected int m_Port;
    protected int m_Timeout;
    protected BaseCharset m_Encoding;
    protected boolean m_OutputString;
    protected transient ServerSocket m_Server;
    protected transient java.net.Socket m_Client;

    public String globalInfo() {
        return "Listens on the specified port for incoming data.\nCan either output raw byte arrays or strings (using the specified encoding).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("port", "port", (Object)8000, (Number)1, (Number)65535);
        this.m_OptionManager.add("timeout", "timeout", (Object)3000, (Number)100, null);
        this.m_OptionManager.add("output-string", "outputString", (Object)false);
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to listen on.";
    }

    public void setTimeout(int value) {
        if (this.getOptionManager().isValid("timeout", (Number)value)) {
            this.m_Timeout = value;
            this.reset();
        }
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public String timeoutTipText() {
        return "The timeout in milli-second for waiting on new client connections.";
    }

    public void setOutputString(boolean value) {
        this.m_OutputString = value;
        this.reset();
    }

    public boolean getOutputString() {
        return this.m_OutputString;
    }

    public String outputStringTipText() {
        return "If enabled, a string with the specified encoding is generated from the incoming byte array.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding for sending the data.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)"listening on ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputString", (Object)(this.m_OutputString ? "string" : "byte[]"), (String)", outputting: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)", encoding: ");
        return result;
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{adams.flow.sink.Socket.class};
    }

    public Class[] generates() {
        if (this.m_OutputString) {
            return new Class[]{String.class};
        }
        return new Class[]{byte[].class};
    }

    protected boolean isPaused() {
        return this.getRoot() instanceof Flow && ((Flow)this.getRoot()).isPaused();
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Server == null) {
            try {
                this.m_Server = new ServerSocket(this.m_Port);
                this.m_Server.setSoTimeout(this.m_Timeout);
                PortManager.getSingleton().bind((Object)this, this.m_Port);
            }
            catch (Exception e) {
                result = this.handleException("Failed to listen on port: " + this.m_Port, e);
                this.m_Server = null;
            }
        }
        if (this.m_Server != null) {
            while (!this.isStopped() && this.m_OutputToken == null) {
                while (this.isPaused() && !this.isStopped()) {
                    Utils.wait((LoggingSupporter)this, (StoppableWithFeedback)this, (int)1000, (int)50);
                }
                if (this.m_Server.isClosed()) break;
                try {
                    int b;
                    this.m_Client = this.m_Server.accept();
                    InputStream in = this.m_Client.getInputStream();
                    TByteArrayList bytes = new TByteArrayList();
                    while ((b = in.read()) != -1) {
                        bytes.add((byte)b);
                    }
                    if (this.m_Client != null) {
                        this.m_Client.close();
                    }
                    this.m_OutputToken = this.m_OutputString ? new Token((Object)new String(bytes.toArray(), this.m_Encoding.charsetValue())) : new Token((Object)bytes.toArray());
                    this.m_Client = null;
                }
                catch (SocketTimeoutException e) {
                }
                catch (SocketException se) {
                    if (this.isStopped()) continue;
                    result = this.handleException("Failed to accept connection!", se);
                }
                catch (Exception e) {
                    result = this.handleException("Failed to accept connection!", e);
                }
            }
        }
        return result;
    }

    public void stopExecution() {
        super.stopExecution();
        if (this.m_Server != null) {
            try {
                if (!this.m_Server.isClosed()) {
                    this.m_Server.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Server = null;
        }
        if (this.m_Client != null) {
            try {
                this.m_Client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Client = null;
        }
    }

    public void wrapUp() {
        if (this.m_Server != null) {
            try {
                if (!this.m_Server.isClosed()) {
                    this.m_Server.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Server = null;
        }
        super.wrapUp();
    }

    public boolean isFinished() {
        return this.m_Server == null;
    }
}

