/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.lister.Sorting;
import adams.core.option.OptionHandler;
import adams.flow.source.filesystemsearch.AbstractFtpDirectoryListerBasedSearchlet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FtpDirectorySearchWithCustomSort
extends AbstractFtpDirectoryListerBasedSearchlet {
    private static final long serialVersionUID = 3229293554987103145L;
    protected BaseRegExp m_SortFind;
    protected String m_SortReplace;
    protected boolean m_Descending;

    public String globalInfo() {
        return "Searches only for directories, but uses a regular expression to reassemble the name and perform the sorting (FTP).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", (Object)"/pub");
        this.m_OptionManager.add("max-items", "maxItems", (Object)-1);
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("sort-find", "sortFind", (Object)new BaseRegExp("([\\s\\S]+)"));
        this.m_OptionManager.add("sort-replace", "sortReplace", (Object)"$0");
        this.m_OptionManager.add("descending", "sortDescending", (Object)false);
        this.m_OptionManager.add("recursive", "recursive", (Object)false);
        this.m_OptionManager.add("max-depth", "maxDepth", (Object)-1);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister.setListDirs(true);
        this.m_Lister.setListFiles(false);
    }

    public void setDirectory(String value) {
        this.m_Lister.setWatchDir(value);
    }

    public String getDirectory() {
        return this.m_Lister.getWatchDir();
    }

    public String directoryTipText() {
        return "The directory to search for directories.";
    }

    public void setMaxItems(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxItems() {
        return this.m_Lister.getMaxItems();
    }

    public String maxItemsTipText() {
        return "The maximum number of dirs to return (<= 0 is unlimited).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the dirs must match (empty string matches all).";
    }

    public void setSortFind(BaseRegExp value) {
        this.m_SortFind = value;
        this.reset();
    }

    public BaseRegExp getSortFind() {
        return this.m_SortFind;
    }

    public String sortFindTipText() {
        return "The regular expression that extracts groups to be used in reassembling the string for sorting.";
    }

    public void setSortReplace(String value) {
        this.m_SortReplace = value;
        this.reset();
    }

    public String getSortReplace() {
        return this.m_SortReplace;
    }

    public String sortReplaceTipText() {
        return "The reassmbly string making use of the groups extracted with the regular expression.";
    }

    public void setSorting(Sorting value) {
        this.m_Lister.setSorting(value);
        this.reset();
    }

    public Sorting getSorting() {
        return this.m_Lister.getSorting();
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_Descending = value;
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Descending;
    }

    public String sortDescendingTipText() {
        return "If set to true, the directories are sorted in descending manner.";
    }

    public void setRecursive(boolean value) {
        this.m_Lister.setRecursive(value);
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Lister.getRecursive();
    }

    public String recursiveTipText() {
        return "Whether to search recursively or not.";
    }

    public void setMaxDepth(int value) {
        this.m_Lister.setMaxDepth(value);
        this.reset();
    }

    public int getMaxDepth() {
        return this.m_Lister.getMaxDepth();
    }

    public String maxDepthTipText() {
        return "The maximum depth to search in recursive mode (1 = only search directory, -1 = infinite).";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"directory", (Object)this.getDirectory());
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sortFind", (BaseRegExp)this.getSortFind(), (String)", find: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sortReplace", (Object)this.getSortReplace(), (String)", replace: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"sortDescending", (boolean)this.getSortDescending(), (String)"descending"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"recursive", (boolean)this.getRecursive(), (String)"recursive"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"maxItems", (Object)(this.getMaxItems() > 0 ? Integer.valueOf(this.getMaxItems()) : null), (String)"max="));
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    protected List<String> doSearch() throws Exception {
        List<String> result = super.doSearch();
        ArrayList<SortContainer> sort = new ArrayList<SortContainer>();
        for (String file : result) {
            sort.add(new SortContainer(file, file.replaceAll(this.m_SortFind.getValue(), this.m_SortReplace)));
        }
        Collections.sort(sort);
        if (this.m_Descending) {
            Collections.reverse(sort);
        }
        result = new ArrayList<String>();
        for (SortContainer cont : sort) {
            result.add(cont.getOriginal());
        }
        return result;
    }

    public static class SortContainer
    implements Serializable,
    Comparable<SortContainer> {
        private static final long serialVersionUID = 8905572097502057181L;
        protected String m_Original;
        protected String m_Comparison;

        public SortContainer(String original, String comparison) {
            this.m_Original = original;
            this.m_Comparison = comparison;
        }

        public String getOriginal() {
            return this.m_Original;
        }

        public String getComparison() {
            return this.m_Comparison;
        }

        @Override
        public int compareTo(SortContainer o) {
            return this.getComparison().compareTo(o.getComparison());
        }

        public String toString() {
            return "comp=" + this.m_Comparison + ", orig=" + this.m_Original;
        }
    }
}

