/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.PasswordPrompter;
import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPConnection
extends AbstractStandalone
implements ProtocolCommandListener,
OptionalPasswordPrompt,
PasswordPrompter {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_Host;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_UsePassiveMode;
    protected boolean m_UseBinaryMode;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected StopMode m_StopMode;
    protected String m_CustomStopMessage;
    protected FTPClient m_Client;

    public String globalInfo() {
        return "Provides access to a FTP host.\nIf debugging is enabled, the FTP commands issued by other actors will get printed as debug output of this actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)"anonymous", false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("passive", "usePassiveMode", (Object)false);
        this.m_OptionManager.add("binary", "useBinaryMode", (Object)false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    protected void reset() {
        super.reset();
        this.disconnect();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)this.m_User);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"password", (Object)this.m_Password.getValue().replaceAll(".", "*"));
        if (value != null) {
            result = (String)result + ":" + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)this.m_Host)) != null) {
            result = (String)result + "@" + value;
        }
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"usePassiveMode", (boolean)this.m_UsePassiveMode, (String)"passive"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useBinaryMode", (boolean)this.m_UseBinaryMode, (String)"binary"));
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
        }
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The FTP user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the FTP user to use for connecting.";
    }

    public void setUsePassiveMode(boolean value) {
        this.m_UsePassiveMode = value;
        this.reset();
    }

    public boolean getUsePassiveMode() {
        return this.m_UsePassiveMode;
    }

    public String usePassiveModeTipText() {
        return "If enabled, passive mode is used instead.";
    }

    public void setUseBinaryMode(boolean value) {
        this.m_UseBinaryMode = value;
        this.reset();
    }

    public boolean getUseBinaryMode() {
        return this.m_UseBinaryMode;
    }

    public String useBinaryModeTipText() {
        return "If enabled, binary mode is used instead of ASCII.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public String doInteract() {
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        String result = dlg.getOption() == 0 ? null : "Interaction canceled!";
        if (result == null) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public String doInteractHeadless() {
        String result = "Interaction canceled!";
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.getName() + "):"));
        if (password != null) {
            result = null;
            this.m_ActualPassword = password;
        }
        return result;
    }

    public synchronized FTPClient getFTPClient() {
        if (this.m_Client == null) {
            this.connect();
        }
        return this.m_Client;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Client == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Starting new session");
            }
            this.m_ActualPassword = this.m_Password;
            if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
                String msg;
                if (!this.isHeadless()) {
                    String msg2 = this.doInteract();
                    if (msg2 != null && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                        } else {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        result = this.getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && (msg = this.doInteractHeadless()) != null && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            }
            if (result == null) {
                result = this.connect();
            }
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("Re-using current session");
        }
        return result;
    }

    protected String connect() {
        Object result = null;
        try {
            this.m_Client = new FTPClient();
            this.m_Client.addProtocolCommandListener((ProtocolCommandListener)this);
            this.m_Client.connect(this.m_Host);
            int reply = this.m_Client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                result = "FTP server refused connection: " + reply;
            } else if (!this.m_Client.login(this.m_User, this.m_ActualPassword.getValue())) {
                result = "Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "'";
            } else {
                if (this.m_UsePassiveMode) {
                    this.m_Client.enterLocalPassiveMode();
                }
                if (this.m_UseBinaryMode) {
                    this.m_Client.setFileType(2);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "': ", e);
            this.m_Client = null;
        }
        return result;
    }

    public void disconnect() {
        if (this.m_Client != null && this.m_Client.isConnected()) {
            try {
                this.m_Client.disconnect();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to disconnect from '" + this.m_Host + "':", (Throwable)e);
            }
            this.m_Client.removeProtocolCommandListener((ProtocolCommandListener)this);
        }
        this.m_Client = null;
    }

    public void wrapUp() {
        this.disconnect();
        super.wrapUp();
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        }
    }
}

