/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.websocket.server.EchoServerGenerator;
import adams.flow.websocket.server.WebSocketServerGenerator;
import java.util.logging.Level;

public class WebSocketServer
extends AbstractStandalone {
    private static final long serialVersionUID = -2959040008316295983L;
    protected WebSocketServerGenerator m_Generator;
    protected transient com.pusher.java_websocket.server.WebSocketServer m_Server;

    public String globalInfo() {
        return "Starts and runs a websocket server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new EchoServerGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_Server = null;
    }

    public void setGenerator(WebSocketServerGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public WebSocketServerGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The server generator to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator);
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Server = this.m_Generator.generateServer();
            if (this.m_Server instanceof FlowContextHandler) {
                ((FlowContextHandler)this.m_Server).setFlowContext((Actor)this);
            }
            this.m_Server.start();
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate/start websocket server!", e);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Server != null) {
            try {
                this.m_Server.stop();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error stopping websocket server!", (Throwable)e);
            }
            this.m_Server = null;
        }
        super.stopExecution();
    }
}

