/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.NullToken;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class CreateEmail
extends AbstractTransformer {
    private static final long serialVersionUID = -5959868605503747649L;
    protected EmailAddress m_Sender;
    protected EmailAddress[] m_Recipients;
    protected EmailAddress[] m_CC;
    protected EmailAddress[] m_BCC;
    protected String m_Subject;
    protected BaseText m_Body;
    protected BaseText m_Signature;

    public String globalInfo() {
        return "Actor for creating emails to be sent. The (optional) attachments are taken from the input.\nVariables in 'subject', 'body' and 'signature' are automatically replaced whenever the actor is executed.\n" + (EmailHelper.isEnabled() ? "" : "Email support not enabled, check email setup!");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sender", "sender", (Object)new EmailAddress(EmailHelper.getDefaultFromAddress()), false);
        this.m_OptionManager.add("recipient", "recipients", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("cc", "CC", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("bcc", "BCC", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("subject", "subject", (Object)"");
        this.m_OptionManager.add("body", "body", (Object)new BaseText(""));
        this.m_OptionManager.add("signature", "signature", (Object)new BaseText(Utils.unbackQuoteChars((String)EmailHelper.getDefaultSignature())));
    }

    public String getQuickInfo() {
        if (!EmailHelper.isEnabled()) {
            return "No email support enabled, check email setup!";
        }
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"sender", (Object)((Object)this.m_Sender), (String)"From: ");
        String value = this.m_Recipients != null && this.m_Recipients.length > 0 ? Utils.flatten((Object[])this.m_Recipients, (String)", ") : "<no recipients>";
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"recipients", (Object)value, (String)", To: ");
        value = this.m_CC != null && this.m_CC.length > 0 ? Utils.flatten((Object[])this.m_CC, (String)", ") : null;
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"CC", (Object)value, (String)", CC: ")) != null) {
            result = (String)result + value;
        }
        value = this.m_BCC != null && this.m_BCC.length > 0 ? Utils.flatten((Object[])this.m_BCC, (String)", ") : null;
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"BCC", (Object)value, (String)", BCC: ")) != null) {
            result = (String)result + value;
        }
        return result;
    }

    public void setSender(EmailAddress value) {
        this.m_Sender = value;
        this.reset();
    }

    public EmailAddress getSender() {
        return this.m_Sender;
    }

    public String senderTipText() {
        return "The sender address to use.";
    }

    public void setRecipients(EmailAddress[] value) {
        this.m_Recipients = value;
        this.reset();
    }

    public EmailAddress[] getRecipients() {
        return this.m_Recipients;
    }

    public String recipientsTipText() {
        return "The recipients to send the email to.";
    }

    public void setCC(EmailAddress[] value) {
        this.m_CC = value;
        this.reset();
    }

    public EmailAddress[] getCC() {
        return this.m_CC;
    }

    public String CCTipText() {
        return "The CC recipients to send the email to.";
    }

    public void setBCC(EmailAddress[] value) {
        this.m_BCC = value;
        this.reset();
    }

    public EmailAddress[] getBCC() {
        return this.m_BCC;
    }

    public String BCCTipText() {
        return "The BCC recipients to send the email to.";
    }

    public void setSubject(String value) {
        this.m_Subject = value;
        this.reset();
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public String subjectTipText() {
        return "The subject of the email, can contain variables.";
    }

    public void setBody(BaseText value) {
        this.m_Body = value;
        this.reset();
    }

    public BaseText getBody() {
        return this.m_Body;
    }

    public String bodyTipText() {
        return "The body of the email, can contain variables.";
    }

    public void setSignature(BaseText value) {
        this.m_Signature = value;
        this.reset();
    }

    public BaseText getSignature() {
        return this.m_Signature;
    }

    public String signatureTipText() {
        return "The signature of the email, gets separated by an extra line consisting of '--', can contain variables.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    public Class[] generates() {
        return new Class[]{Email.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !EmailHelper.isEnabled()) {
            result = "No email support enabled, check email setup!";
        }
        if (result == null && !QuickInfoHelper.hasVariable((OptionHandler)this, (String)"recipients") && this.m_Recipients.length == 0) {
            result = "At least one email recipient must be defined!";
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile[] attachments = this.m_InputToken == null || this.m_InputToken instanceof NullToken ? new PlaceholderFile[]{} : FileUtils.toPlaceholderFileArray((Object)this.m_InputToken.getPayload());
        String subject = this.getVariables().expand(this.m_Subject);
        String body = EmailHelper.combine(this.getVariables().expand(this.m_Body.getValue()), this.getVariables().expand(this.m_Signature.getValue()));
        try {
            Email email = new Email(this.m_Sender, this.m_Recipients, this.m_CC, this.m_BCC, subject, body, (File[])attachments);
            if (this.isLoggingEnabled()) {
                this.getLogger().info(email.toString());
            }
            this.m_OutputToken = new Token((Object)email);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate email!", e);
        }
        return result;
    }
}

