/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.net.Email;
import adams.core.option.OptionHandler;
import adams.data.io.input.MultiEmailReader;
import adams.data.io.input.PropertiesEmailFileReader;
import adams.flow.transformer.AbstractArrayProvider;
import java.io.File;
import java.util.List;

public class EmailFileReader
extends AbstractArrayProvider {
    private static final long serialVersionUID = -1585651878523228177L;
    protected adams.data.io.input.EmailFileReader m_Reader;

    public String globalInfo() {
        return "Reads email(s) from a file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new PropertiesEmailFileReader());
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"reader", (Object)this.m_Reader, (String)"reader: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)(this.m_OutputArray ? "as array" : "one-by-one"), (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    protected Class getItemClass() {
        return Email.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the emails get output as array rather than one-by-one.";
    }

    public void setReader(adams.data.io.input.EmailFileReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public adams.data.io.input.EmailFileReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader for reading the emails.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        PlaceholderFile file = fileObj instanceof File ? new PlaceholderFile((File)fileObj) : new PlaceholderFile((String)fileObj);
        this.m_Reader.setInput(file);
        try {
            if (this.m_Reader instanceof MultiEmailReader) {
                List<Email> emails = ((MultiEmailReader)((Object)this.m_Reader)).readAll();
                this.m_Queue.addAll(emails);
            } else {
                Email email = this.m_Reader.read();
                this.m_Queue.add(email);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to write email(s)!", e);
        }
        return result;
    }
}

