/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.core.io.EncodingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.container.HttpRequestResult;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.github.fracpete.requests4j.core.MediaTypeHelper;
import com.github.fracpete.requests4j.request.Method;
import com.github.fracpete.requests4j.request.Request;
import com.github.fracpete.requests4j.response.BasicResponse;
import okhttp3.MediaType;

public class HttpRequest
extends AbstractTransformer
implements EncodingSupporter {
    private static final long serialVersionUID = 3114594997972970790L;
    protected BaseURL m_URL;
    protected Method m_Method;
    protected String m_MimeType;
    protected BaseKeyValuePair[] m_Headers;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "Sends the incoming text/bytes payload to the specified URL (with optional HTTP headers) and forwards the retrieved HTML as text.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL());
        this.m_OptionManager.add("method", "method", (Object)Method.POST);
        this.m_OptionManager.add("mime-type", "mimeType", (Object)"");
        this.m_OptionManager.add("header", "headers", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset("UTF-8"));
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)this.m_URL, (String)"URL: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"method", (Object)this.m_Method, (String)", method: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"mimeType", (Object)(this.m_MimeType.isEmpty() ? MediaTypeHelper.OCTECT_STREAM : this.m_MimeType), (String)", mime-type: ");
        return result;
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL for the request.";
    }

    public void setMethod(Method value) {
        this.m_Method = value;
        this.reset();
    }

    public Method getMethod() {
        return this.m_Method;
    }

    public String methodTipText() {
        return "The method to use for the request.";
    }

    public void setMimeType(String value) {
        this.m_MimeType = value;
        this.reset();
    }

    public String getMimeType() {
        return this.m_MimeType;
    }

    public String mimeTypeTipText() {
        return "The mime-type for the request, leave empty for " + MediaTypeHelper.OCTECT_STREAM + ".";
    }

    public void setHeaders(BaseKeyValuePair[] value) {
        this.m_Headers = value;
        this.reset();
    }

    public BaseKeyValuePair[] getHeaders() {
        return this.m_Headers;
    }

    public String headersTipText() {
        return "The (optional) request headers to send.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for incoming strings.";
    }

    public Class[] accepts() {
        return new Class[]{byte[].class, String.class};
    }

    public Class[] generates() {
        return new Class[]{HttpRequestResult.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Request req = new Request(this.m_Method).url(this.m_URL.urlValue()).headers(BaseKeyValuePair.toMap((BaseKeyValuePair[])this.m_Headers));
            if (!this.m_Method.hasBody()) {
                throw new IllegalStateException("Method " + this.m_Method + " does not support a body in the request!");
            }
            byte[] bytes = this.m_InputToken.hasPayload(String.class) ? ((String)this.m_InputToken.getPayload()).getBytes(this.m_Encoding.charsetValue()) : (byte[])this.m_InputToken.getPayload();
            if (this.m_MimeType.isEmpty()) {
                req.body(bytes);
            } else {
                req.body(bytes, MediaType.parse((String)this.m_MimeType));
            }
            BasicResponse res = req.execute();
            this.m_OutputToken = new Token((Object)new HttpRequestResult(res.statusCode(), res.statusMessage(), res.text()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute request: " + this.m_URL, e);
        }
        return result;
    }
}

