/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.io.fileoperations.RemoteDirection;
import adams.core.io.fileoperations.SftpFileOperations;
import adams.core.net.JSchUtils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.SSHConnection;
import adams.flow.transformer.AbstractTransformer;

@MixedCopyright(copyright="JCraft", license=License.BSD3, url="https://github.com/mwiede/jsch")
public class SFTPDelete
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Deletes a remote file via secure FTP (SFTP) and forwards the deleted file name.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return JSchUtils.getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)(this.m_RemoteDir.isEmpty() ? "<incoming>" : this.m_RemoteDir), (String)"delete from ");
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The SFTP directory to delete the file from.";
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((Actor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String file = (String)this.m_InputToken.getPayload();
        String remotefile = (String)(this.m_RemoteDir.isEmpty() ? "" : this.m_RemoteDir + "/") + file;
        SftpFileOperations ops = new SftpFileOperations();
        ops.setProvider(this.m_Connection);
        ops.setDirection(RemoteDirection.REMOTE_TO_LOCAL);
        String result = ops.delete(remotefile);
        return result;
    }
}

