/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.net.SMB;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SMBConnection;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class SMBGet
extends AbstractTransformer {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_Host;
    protected String m_RemoteDir;
    protected PlaceholderDirectory m_OutputDirectory;
    protected SMBConnection m_Connection;

    public String globalInfo() {
        return "Downloads a remote file and forwards the local file name (SMB, Windows share).\nHost and remote directory can be left empty if the incoming filename consists of a fully qualified URL, e.g.: smb://host/share/dir/file.txt";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"");
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)(this.m_Host.isEmpty() ? "-none-" : this.m_Host), (String)"host: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)(this.m_RemoteDir.isEmpty() ? "-none-" : this.m_RemoteDir), (String)", remote dir: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputDirectory", (Object)this.m_OutputDirectory, (String)", output: ");
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to download the file from.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory to store the downloaded files in.";
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (SMBConnection)ActorUtils.findClosestType((Actor)this, SMBConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SMBConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String file = (String)this.m_InputToken.getPayload();
        Object remoteFile = file.startsWith("smb:") ? file : "smb://" + this.m_Host + (this.m_RemoteDir.startsWith("/") ? "" : "/") + this.m_RemoteDir + "/" + file;
        PlaceholderFile localFile = new PlaceholderFile(this.m_OutputDirectory.getAbsolutePath() + File.separator + new File(file).getName());
        String result = SMB.copyFrom((LoggingObject)this, this.m_Connection, (String)remoteFile, (File)localFile);
        this.m_OutputToken = result == null ? new Token((Object)localFile) : null;
        return result;
    }
}

