/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.net.SMB;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SMBConnection;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class SMBSend
extends AbstractTransformer {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_Host;
    protected String m_RemoteDir;
    protected SMBConnection m_Connection;

    public String globalInfo() {
        return "Uploads a file to a remote directory (SMB, Windows share).\nThe file name of a successful upload gets forwarded.\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"");
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)(this.m_Host.isEmpty() ? "-none-" : this.m_Host), (String)"host: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)(this.m_RemoteDir.isEmpty() ? "-none-" : this.m_RemoteDir), (String)", remote dir: ");
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to upload the file to.";
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (SMBConnection)ActorUtils.findClosestType((Actor)this, SMBConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SMBConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String remoteFile;
        String filename = (String)this.m_InputToken.getPayload();
        PlaceholderFile localFile = new PlaceholderFile(filename);
        String result = SMB.copyTo((LoggingObject)this, this.m_Connection, (File)localFile, remoteFile = "smb://" + this.m_Host + "/" + this.m_RemoteDir + "/" + localFile.getName());
        this.m_OutputToken = result == null ? new Token((Object)filename) : null;
        return result;
    }
}

