/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.websocket.client;

import adams.core.QuickInfoHelper;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.websocket.client.AbstractWebSocketClientGenerator;
import adams.flow.websocket.client.SimpleSendWithQueue;
import adams.flow.websocket.server.EchoServer;
import com.pusher.java_websocket.client.WebSocketClient;

public class SimpleSendWithQueueGenerator
extends AbstractWebSocketClientGenerator {
    private static final long serialVersionUID = -1431160448984414483L;
    protected StorageName m_StorageName;

    public String globalInfo() {
        return "Generates the " + SimpleSendWithQueue.class.getName() + " client.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("queue"));
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)", storage: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    @Override
    protected WebSocketClient doGenerate() {
        Logger logger = LoggingHelper.getLogger(EchoServer.class);
        logger.setLevel(this.getLoggingLevel().getLevel());
        return new SimpleSendWithQueue(this.m_URL.uriValue(), logger, this.m_StorageName);
    }
}

