/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.ClassLister;
import adams.core.classmanager.ClassManager;
import adams.data.io.input.EmailFileReader;
import adams.data.io.input.PropertiesEmailFileReader;
import adams.data.io.output.EmailFileWriter;
import adams.data.io.output.PropertiesEmailFileWriter;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.chooser.FileTypeDeterminingFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmailFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<EmailFileReader, EmailFileWriter>
implements FileTypeDeterminingFileChooser<EmailFileReader, EmailFileWriter> {
    private static final long serialVersionUID = -6341967475735162796L;
    protected static List<ExtensionFileFilterWithClass> m_ReaderFileFilters;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    public EmailFileChooser() {
    }

    public EmailFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public EmailFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    protected void doInitializeFilters() {
        EmailFileChooser.initFilters(true, ClassLister.getSingleton().getClassnames(EmailFileReader.class));
        EmailFileChooser.initFilters(false, ClassLister.getSingleton().getClassnames(EmailFileWriter.class));
    }

    protected static void initFilters(boolean reader, String[] classnames) {
        if (reader && m_ReaderFileFilters != null) {
            return;
        }
        if (!reader && m_WriterFileFilters != null) {
            return;
        }
        if (reader) {
            m_ReaderFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        } else {
            m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        }
        for (int i = 0; i < classnames.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class cls;
            String classname = classnames[i];
            try {
                cls = ClassManager.getSingleton().forName(classname);
                converter = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (reader) {
                    desc = ((EmailFileReader)converter).getFormatDescription();
                    ext = ((EmailFileReader)converter).getFormatExtensions();
                } else {
                    desc = ((EmailFileWriter)converter).getFormatDescription();
                    ext = ((EmailFileWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                EmailFileChooser.handleException((String)("Failed to set up: " + classname), (Throwable)e);
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    protected void initGUI(int dialogType) {
        super.initGUI(dialogType);
        if (dialogType == 0) {
            this.m_Editor.setClassType(EmailFileReader.class);
            this.m_Editor.setValue((Object)this.getDefaultReader());
        } else {
            this.m_Editor.setClassType(EmailFileWriter.class);
            this.m_Editor.setValue((Object)this.getDefaultWriter());
        }
        this.restoreLastFilter(dialogType);
    }

    protected Class getReaderClass() {
        return EmailFileReader.class;
    }

    protected Class getWriterClass() {
        return EmailFileWriter.class;
    }

    protected EmailFileReader getDefaultReader() {
        return new PropertiesEmailFileReader();
    }

    protected EmailFileWriter getDefaultWriter() {
        return new PropertiesEmailFileWriter();
    }

    protected void updateCurrentHandlerHook() {
        try {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            Object newHandler = ClassManager.getSingleton().forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            this.setFileSelectionMode(0);
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            EmailFileChooser.handleException((String)"Failed to update current handler:", (Throwable)e);
        }
    }

    protected void configureCurrentHandlerHook(int dialogType) {
        if (this.m_CurrentHandler == null) {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = ClassManager.getSingleton().forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                this.m_CurrentHandler = null;
                EmailFileChooser.handleException((String)"Failed to configure current handler:", (Throwable)e);
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
    }

    public EmailFileReader getReaderForFile(File file) {
        return EmailFileChooser.readerForFile(file);
    }

    public EmailFileWriter getWriterForFile(File file) {
        return EmailFileChooser.writerForFile(file);
    }

    public static EmailFileReader readerForFile(File file) {
        EmailFileReader result = null;
        EmailFileChooser.initFilters(true, ClassLister.getSingleton().getClassnames(EmailFileReader.class));
        for (ExtensionFileFilterWithClass filter : m_ReaderFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (EmailFileReader)ClassManager.getSingleton().forName(filter.getClassname()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                EmailFileChooser.handleException((String)("Failed to instantiate reader: " + filter.getClassname()), (Throwable)e);
            }
        }
        return result;
    }

    public static EmailFileWriter writerForFile(File file) {
        EmailFileWriter result = null;
        EmailFileChooser.initFilters(false, ClassLister.getSingleton().getClassnames(EmailFileWriter.class));
        for (ExtensionFileFilterWithClass filter : m_WriterFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (EmailFileWriter)ClassManager.getSingleton().forName(filter.getClassname()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                EmailFileChooser.handleException((String)("Failed to instantiate writer: " + filter.getClassname()), (Throwable)e);
            }
        }
        return result;
    }
}

