/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.fileoperations.FileOperations;
import adams.core.io.fileoperations.FtpFileOperations;
import adams.core.io.lister.DirectoryLister;
import adams.core.io.lister.FtpDirectoryLister;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanelWithIOSupport;
import adams.gui.chooser.FtpRemoteDirectorySetup;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Dialog;
import org.apache.commons.net.ftp.FTPClient;

public class FtpDirectoryChooserPanel
extends AbstractChooserPanelWithIOSupport<FtpRemoteDirectorySetup> {
    private static final long serialVersionUID = 6235369491956122980L;
    protected FTPClient m_Client;

    public FtpDirectoryChooserPanel() {
        this.setCurrent(new FtpRemoteDirectorySetup());
    }

    protected void initialize() {
        super.initialize();
        this.reset();
    }

    protected void reset() {
        this.m_Client = null;
    }

    public boolean setCurrent(FtpRemoteDirectorySetup value) {
        boolean result = super.setCurrent((Object)value);
        if (result) {
            this.reset();
        }
        return result;
    }

    protected FtpRemoteDirectorySetup doChoose() {
        FtpRemoteDirectorySetup currentSetup = (FtpRemoteDirectorySetup)((Object)this.getCurrent());
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Remote directory");
        dialog.setUISettingsPrefix(FtpRemoteDirectorySetup.class);
        dialog.getGOEEditor().setClassType(FtpRemoteDirectorySetup.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(false);
        dialog.setCurrent((Object)currentSetup);
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)this)));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return null;
        }
        FtpRemoteDirectorySetup newSetup = (FtpRemoteDirectorySetup)((Object)dialog.getCurrent());
        if (!newSetup.toCommandLine().equals(currentSetup.toCommandLine())) {
            this.reset();
        }
        return newSetup;
    }

    protected String toString(FtpRemoteDirectorySetup value) {
        return value.toCommandLine();
    }

    protected FtpRemoteDirectorySetup fromString(String value) {
        try {
            return (FtpRemoteDirectorySetup)((Object)OptionUtils.forAnyCommandLine(FtpRemoteDirectorySetup.class, (String)value));
        }
        catch (Exception e) {
            return new FtpRemoteDirectorySetup();
        }
    }

    public void setCurrentDirectory(String value) {
        FtpRemoteDirectorySetup current = (FtpRemoteDirectorySetup)((Object)this.getCurrent());
        current.setRemoteDir(value);
        this.setCurrent(current);
    }

    public String getCurrentDirectory() {
        return ((FtpRemoteDirectorySetup)((Object)this.getCurrent())).getRemoteDir();
    }

    public String getChooserType() {
        return "FTP";
    }

    protected synchronized FTPClient getClient() {
        if (this.m_Client == null || !this.m_Client.isConnected()) {
            this.m_Client = ((FtpRemoteDirectorySetup)((Object)this.getCurrent())).getClient();
        }
        return this.m_Client;
    }

    public DirectoryLister getDirectoryLister() {
        FtpRemoteDirectorySetup current = (FtpRemoteDirectorySetup)((Object)this.getCurrent());
        FtpDirectoryLister result = new FtpDirectoryLister();
        result.setClient(this.getClient());
        result.setWatchDir(current.getRemoteDir());
        return result;
    }

    public FileOperations getFileOperations() {
        FtpFileOperations result = new FtpFileOperations();
        result.setClient(this.getClient());
        return result;
    }
}

