/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.notificationareaaction;

import adams.core.DateUtils;
import adams.core.SystemInfo;
import adams.core.io.FileUtils;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingLevel;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.flow.notificationareaaction.AbstractNotificationAreaAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class SendErrorReport
extends AbstractNotificationAreaAction {
    private static final long serialVersionUID = -2884370713454014768L;

    public SendErrorReport() {
        this.setName("Send error report...");
        this.setIcon(ImageManager.getIcon((String)"email.png"));
    }

    protected void doActionPerformed(ActionEvent e) {
        final String comment = GUIHelper.showInputDialog(null, (String)"Please supply some additional information on error report");
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                File file;
                SwingUtilities.invokeLater(() -> SendErrorReport.this.m_Owner.getOwner().showStatus("Preparing error report..."));
                String console = ConsolePanel.getSingleton().getPanel(ConsolePanel.PanelType.ALL).getContent();
                SpreadSheet info = new SystemInfo().toSpreadSheet();
                ArrayList<File> atts = new ArrayList<File>();
                File prefix = TempUtils.createTempFile((String)"errorreport", null);
                if (SendErrorReport.this.m_Owner.getOwner().getLastFlow() != null) {
                    file = new File(prefix.getAbsolutePath() + ".flow");
                    if (ActorUtils.write((String)file.getAbsolutePath(), (Actor)SendErrorReport.this.m_Owner.getOwner().getLastFlow())) {
                        atts.add(file);
                    } else {
                        ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, "Failed to save current flow to: " + file);
                    }
                }
                if (FileUtils.writeToFile((String)(file = new File(prefix.getAbsolutePath() + ".txt")).getAbsolutePath(), (Object)console, (boolean)false)) {
                    atts.add(file);
                } else {
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, "Failed to write console panel content for error report to: " + file);
                }
                file = new File(prefix.getAbsolutePath() + ".csv");
                CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
                if (writer.write(info, file)) {
                    atts.add(file);
                } else {
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, "Failed to write system info for error report to: " + file);
                }
                SwingUtilities.invokeLater(() -> SendErrorReport.this.m_Owner.getOwner().showStatus("Sending error report..."));
                Email email = new Email(new EmailAddress(EmailHelper.getDefaultFromAddress()), new EmailAddress(EmailHelper.getSupportEmail()), Environment.getInstance().getProject() + " error report", "Error report generated at " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\nSee attachements for details" + (String)(comment == null ? "" : "\nUser comment:\n" + comment), atts.toArray(new File[atts.size()]));
                AbstractSendEmail sendEmail = EmailHelper.getDefaultSendEmail();
                try {
                    if (sendEmail.requiresSmtpSessionInitialization()) {
                        sendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword(), EmailHelper.getSmtpProtocols());
                    }
                    sendEmail.sendMail(email);
                    SwingUtilities.invokeLater(() -> SendErrorReport.this.m_Owner.getOwner().showStatus("Error report sent!"));
                    GUIHelper.showInformationMessage(null, (String)("Error report sent to " + EmailHelper.getSupportEmail()));
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage(null, (String)"Failed to send error report email!", (Throwable)ex);
                }
                return null;
            }

            @Override
            protected void done() {
                SwingUtilities.invokeLater(() -> SendErrorReport.this.m_Owner.getOwner().showStatus(""));
                super.done();
            }
        };
        worker.execute();
    }

    public void update() {
        this.setEnabled(EmailHelper.isEnabled() && !EmailHelper.getSupportEmail().isEmpty() && !EmailHelper.getDefaultFromAddress().isEmpty());
    }
}

