/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.net.EmailAddress;
import adams.core.net.EmailAddressBook;
import adams.core.net.EmailContact;
import adams.core.option.parsing.EmailAddressParsing;
import adams.gui.core.BaseButton;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.DoubleClickEvent;
import adams.gui.event.DoubleClickListener;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.selection.SelectEmailAddressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EmailAddressEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected SelectEmailAddressPanel m_SelectPanel;
    protected BaseButton m_ButtonOK;
    protected BaseButton m_ButtonClose;

    public String toCustomStringRepresentation(Object obj) {
        return EmailAddressParsing.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return EmailAddressParsing.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        EmailAddress email = (EmailAddress)((Object)this.getValue());
        Object result = email == null ? "null" : "new " + EmailAddress.class.getName() + "(\"" + email.toString() + "\")";
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panel = new JPanel(new BorderLayout());
        this.m_SelectPanel = new SelectEmailAddressPanel();
        this.m_SelectPanel.addDoubleClickListener(new DoubleClickListener(){

            public void doubleClickOccurred(DoubleClickEvent e) {
                if (EmailAddressEditor.this.m_SelectPanel.getItem() != null) {
                    EmailAddressEditor.this.m_ButtonOK.doClick();
                }
            }
        });
        panel.add((Component)((Object)this.m_SelectPanel), "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panel.add((Component)panelButtons, "South");
        this.m_ButtonOK = new BaseButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EmailAddressEditor.this.m_SelectPanel.getItem() != null) {
                    EmailAddress field = ((EmailContact)EmailAddressEditor.this.m_SelectPanel.getItem()).toEmailAddress();
                    EmailAddress current = (EmailAddress)((Object)EmailAddressEditor.this.getValue());
                    if (!current.equals((Object)field)) {
                        EmailAddressEditor.this.setValue((Object)field);
                    }
                }
                EmailAddressEditor.this.closeDialog(1);
            }
        });
        panelButtons.add((Component)this.m_ButtonOK);
        this.m_ButtonClose = new BaseButton("Cancel");
        this.m_ButtonClose.setMnemonic('C');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailAddressEditor.this.m_SelectPanel.setItem(EmailAddressBook.getSingleton().getContact((EmailAddress)((Object)EmailAddressEditor.this.getValue())));
                EmailAddressEditor.this.closeDialog(0);
            }
        });
        panelButtons.add((Component)this.m_ButtonClose);
        return panel;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        this.m_SelectPanel.setMultipleSelection(false);
        this.m_SelectPanel.setItem(EmailAddressBook.getSingleton().getContact((EmailAddress)((Object)this.getValue())));
        this.m_SelectPanel.scrollIntoView();
        this.m_SelectPanel.grabFocus();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        EmailAddress curr = (EmailAddress)((Object)this.getValue());
        String val = curr.stringValue();
        if (val == null) {
            val = "";
        }
        if (val.isEmpty()) {
            val = "[empty]";
        }
        GUIHelper.configureAntiAliasing((Graphics)gfx, (boolean)true);
        int[] offset = GUIHelper.calculateFontOffset((Graphics)gfx, (Rectangle)box);
        gfx.drawString(val, offset[0], offset[1]);
    }

    public Object[] getSelectedObjects(Container parent) {
        EmailAddress[] result;
        final ApprovalDialog dialog = ApprovalDialog.getDialog((Dialog)GUIHelper.getParentDialog((Container)parent));
        final SelectEmailAddressPanel panel = new SelectEmailAddressPanel();
        panel.addDoubleClickListener(new DoubleClickListener(){

            public void doubleClickOccurred(DoubleClickEvent e) {
                if (panel.getItem() != null) {
                    dialog.getApproveButton().doClick();
                }
            }
        });
        panel.setMultipleSelection(true);
        panel.setItem(null);
        dialog.getContentPane().add((Component)((Object)panel), "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            EmailContact[] contacts = (EmailContact[])panel.getItems();
            result = new EmailAddress[contacts.length];
            for (int i = 0; i < contacts.length; ++i) {
                result[i] = contacts[i].toEmailAddress();
            }
        } else {
            result = new EmailAddress[]{};
        }
        return result;
    }
}

