/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.management.User;
import adams.core.net.SSHAuthenticationType;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BasePasswordField;
import adams.gui.core.BaseTextField;
import adams.gui.core.BaseTextPaneWithButtons;
import adams.gui.core.BaseTextPaneWithWordWrap;
import adams.gui.core.ConsolePanel;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

@MixedCopyright(copyright="JCraft", license=License.BSD3, url="http://www.jcraft.com/jsch/examples/Shell.java", note="Code adapted from Shell")
public class SSHPanel
extends BasePanel
implements LoggingSupporter {
    private static final long serialVersionUID = 6647177121906710884L;
    protected BaseTextField m_TextRemote;
    protected SpinnerNumberModel m_PortModel;
    protected JSpinner m_SpinnerPort;
    protected BaseButton m_ButtonConnection;
    protected FileChooserPanel m_FileChooserPanelKnownHosts;
    protected HashMap<SSHAuthenticationType, JPanel> m_AuthenticationPanels;
    protected JPanel m_PanelAuthentication;
    protected BaseComboBox<SSHAuthenticationType> m_ComboBoxAuthenticationType;
    protected FileChooserPanel m_FileChooserPanelKey;
    protected BasePasswordField m_TextKeyPassphrase;
    protected BaseTextField m_TextUser;
    protected BasePasswordField m_TextPassword;
    protected BaseTextPaneWithButtons m_TextOutput;
    protected BaseButton m_ButtonClear;
    protected BaseButton m_ButtonCopy;
    protected BaseTextField m_TextCommand;
    protected BaseButton m_ButtonCommand;
    protected Session m_Session;
    protected Channel m_Channel;
    protected List<String> m_CommandHistory;
    protected int m_CommandIndex;
    protected adams.core.logging.Logger m_Logger;
    protected SimpleAttributeSet m_AttributeSetCmd;
    protected SimpleAttributeSet m_AttributeSetRemote;
    protected SimpleAttributeSet m_AttributeSetError;

    protected void initialize() {
        super.initialize();
        this.m_CommandIndex = 0;
        this.m_CommandHistory = new ArrayList<String>();
        this.m_CommandHistory.add("");
        this.m_Session = null;
        this.m_AuthenticationPanels = new HashMap();
        this.m_AttributeSetCmd = new SimpleAttributeSet();
        StyleConstants.setForeground(this.m_AttributeSetCmd, Color.BLACK);
        StyleConstants.setFontFamily(this.m_AttributeSetCmd, "monospaced");
        StyleConstants.setBold(this.m_AttributeSetCmd, true);
        this.m_AttributeSetRemote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.m_AttributeSetRemote, Color.BLACK);
        StyleConstants.setFontFamily(this.m_AttributeSetRemote, "monospaced");
        StyleConstants.setBold(this.m_AttributeSetRemote, false);
        this.m_AttributeSetError = new SimpleAttributeSet();
        StyleConstants.setForeground(this.m_AttributeSetError, Color.RED);
        StyleConstants.setFontFamily(this.m_AttributeSetError, "monospaced");
        StyleConstants.setBold(this.m_AttributeSetError, false);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel topPanels = new JPanel(new GridLayout(3, 1));
        this.add(topPanels, "North");
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanels.add(topPanel);
        this.m_TextRemote = new BaseTextField(20);
        JLabel label = new JLabel("Remote");
        label.setDisplayedMnemonic('R');
        label.setLabelFor((Component)this.m_TextRemote);
        topPanel.add(label);
        topPanel.add((Component)this.m_TextRemote);
        this.m_PortModel = new SpinnerNumberModel();
        this.m_PortModel.setMinimum(Integer.valueOf(1));
        this.m_PortModel.setMaximum(Integer.valueOf(65536));
        this.m_PortModel.setStepSize(1);
        this.m_PortModel.setValue(22);
        this.m_SpinnerPort = new JSpinner(this.m_PortModel);
        label = new JLabel("Port");
        label.setDisplayedMnemonic('P');
        label.setLabelFor(this.m_SpinnerPort);
        topPanel.add(label);
        topPanel.add(this.m_SpinnerPort);
        this.m_ButtonConnection = new BaseButton();
        this.m_ButtonConnection.setMnemonic('n');
        this.m_ButtonConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHPanel.this.handleConnectionEvent();
            }
        });
        topPanel.add((Component)this.m_ButtonConnection);
        JPanel panel = new JPanel(new FlowLayout(0));
        topPanels.add(panel);
        this.m_FileChooserPanelKnownHosts = new FileChooserPanel(User.getHomeDir() + File.separator + ".ssh" + File.separator + "known_hosts");
        this.m_FileChooserPanelKnownHosts.setPrefix("Known hosts file");
        panel.add((Component)this.m_FileChooserPanelKnownHosts);
        this.m_PanelAuthentication = new JPanel(new BorderLayout());
        topPanels.add(this.m_PanelAuthentication);
        for (SSHAuthenticationType type : SSHAuthenticationType.values()) {
            JPanel authPanel = new JPanel(new FlowLayout(0));
            switch (type) {
                case CREDENTIALS: {
                    this.m_TextUser = new BaseTextField(8);
                    this.m_TextUser.setText(User.getName());
                    label = new JLabel("User");
                    label.setLabelFor((Component)this.m_TextUser);
                    authPanel.add(label);
                    authPanel.add((Component)this.m_TextUser);
                    this.m_TextPassword = new BasePasswordField(8);
                    label = new JLabel("Password");
                    label.setLabelFor((Component)this.m_TextPassword);
                    authPanel.add(label);
                    authPanel.add((Component)this.m_TextPassword);
                    break;
                }
                case PUBLIC_KEY: {
                    this.m_TextUser = new BaseTextField(8);
                    this.m_TextUser.setText(User.getName());
                    label = new JLabel("User");
                    label.setLabelFor((Component)this.m_TextUser);
                    authPanel.add(label);
                    authPanel.add((Component)this.m_TextUser);
                    this.m_FileChooserPanelKey = new FileChooserPanel(User.getHomeDir() + File.separator + ".ssh" + File.separator + "id_rsa");
                    this.m_FileChooserPanelKey.setPrefix("Private key");
                    this.m_FileChooserPanelKey.setPreferredSize(new Dimension(250, GUIHelper.getInteger((String)"GOEDefaultHeight", (Integer)20)));
                    authPanel.add((Component)this.m_FileChooserPanelKey);
                    this.m_TextKeyPassphrase = new BasePasswordField(8);
                    label = new JLabel("Passphrase");
                    label.setLabelFor((Component)this.m_TextKeyPassphrase);
                    authPanel.add(label);
                    authPanel.add((Component)this.m_TextKeyPassphrase);
                    break;
                }
                default: {
                    authPanel.add(new JLabel("Unsupported"));
                }
            }
            this.m_AuthenticationPanels.put(type, authPanel);
        }
        this.m_ComboBoxAuthenticationType = new BaseComboBox((Object[])SSHAuthenticationType.values());
        this.m_ComboBoxAuthenticationType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHPanel.this.m_PanelAuthentication.removeAll();
                JPanel panel = new JPanel(new FlowLayout(0));
                panel.add((Component)SSHPanel.this.m_ComboBoxAuthenticationType, "North");
                SSHPanel.this.m_PanelAuthentication.add((Component)panel, "West");
                SSHPanel.this.m_PanelAuthentication.add(SSHPanel.this.m_AuthenticationPanels.get(SSHPanel.this.m_ComboBoxAuthenticationType.getSelectedItem()));
                SSHPanel.this.m_PanelAuthentication.getParent().invalidate();
                SSHPanel.this.m_PanelAuthentication.getParent().revalidate();
                SSHPanel.this.m_PanelAuthentication.getParent().repaint();
            }
        });
        this.m_ComboBoxAuthenticationType.setSelectedIndex(0);
        this.m_ButtonClear = new BaseButton("Clear", (Icon)ImageManager.getIcon((String)"new.gif"));
        this.m_ButtonClear.setMnemonic('l');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHPanel.this.clear();
            }
        });
        this.m_ButtonCopy = new BaseButton("Copy", (Icon)ImageManager.getIcon((String)"copy.gif"));
        this.m_ButtonCopy.setMnemonic('C');
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSHPanel.this.m_TextOutput.getSelectedText().length() > 0) {
                    ClipboardHelper.copyToClipboard((String)SSHPanel.this.m_TextOutput.getSelectedText());
                } else if (SSHPanel.this.m_TextOutput.getText().length() > 0) {
                    ClipboardHelper.copyToClipboard((String)SSHPanel.this.m_TextOutput.getText());
                }
            }
        });
        this.m_TextOutput = new BaseTextPaneWithButtons();
        this.m_TextOutput.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TextOutput.setTextFont(Fonts.getMonospacedFont());
        this.m_TextOutput.addToButtonsPanel((Component)this.m_ButtonClear);
        this.m_TextOutput.addToButtonsPanel((Component)this.m_ButtonCopy);
        this.add((Component)this.m_TextOutput, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(0));
        this.add(bottomPanel, "South");
        this.m_TextCommand = new BaseTextField(40);
        this.m_TextCommand.setFont(Fonts.getMonospacedFont());
        this.m_TextCommand.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                        SSHPanel.this.execCommand();
                        break;
                    }
                    case 38: {
                        e.consume();
                        SSHPanel.this.previousCommand();
                        break;
                    }
                    case 40: {
                        e.consume();
                        SSHPanel.this.nextCommand();
                    }
                }
            }
        });
        label = new JLabel("Command");
        label.setDisplayedMnemonic('m');
        label.setLabelFor((Component)this.m_TextCommand);
        bottomPanel.add(label);
        bottomPanel.add((Component)this.m_TextCommand);
        this.m_ButtonCommand = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
        this.m_ButtonCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHPanel.this.execCommand();
            }
        });
        bottomPanel.add((Component)this.m_ButtonCommand);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    protected void previousCommand() {
        this.m_CommandIndex = this.m_CommandIndex > 0 ? --this.m_CommandIndex : this.m_CommandHistory.size() - 1;
        if (this.m_CommandIndex < 0) {
            this.m_CommandIndex = 0;
        }
        if (this.m_CommandIndex < this.m_CommandHistory.size()) {
            this.m_TextCommand.setText(this.m_CommandHistory.get(this.m_CommandIndex));
        }
    }

    protected void nextCommand() {
        this.m_CommandIndex = this.m_CommandIndex < this.m_CommandHistory.size() - 1 ? ++this.m_CommandIndex : 0;
        if (this.m_CommandIndex >= this.m_CommandHistory.size()) {
            this.m_CommandIndex = 0;
        }
        if (this.m_CommandIndex < this.m_CommandHistory.size()) {
            this.m_TextCommand.setText(this.m_CommandHistory.get(this.m_CommandIndex));
        }
    }

    protected void append(String msg, AttributeSet a) {
        ((BaseTextPaneWithWordWrap)this.m_TextOutput.getComponent()).append(msg + (msg.endsWith("\n") ? "" : "\n"), a);
        this.m_TextOutput.setCaretPosition(this.m_TextOutput.getDocument().getLength());
    }

    protected boolean canConnect() {
        return this.m_TextRemote.getText().trim().length() > 0;
    }

    protected void handleConnectionEvent() {
        String msg = "??";
        try {
            if (this.isConnected()) {
                msg = "disconnect";
                this.m_Session.disconnect();
                this.updateButtons();
            } else if (this.canConnect()) {
                msg = "connect";
                JSch jsch = new JSch();
                JSch.setLogger((Logger)new Logger(){

                    public boolean isEnabled(int level) {
                        return true;
                    }

                    public void log(int level, String message) {
                        switch (level) {
                            case 0: {
                                SSHPanel.this.getLogger().fine(message);
                                break;
                            }
                            case 1: {
                                SSHPanel.this.getLogger().info(message);
                                break;
                            }
                            case 2: {
                                SSHPanel.this.getLogger().warning(message);
                                break;
                            }
                            case 3: 
                            case 4: {
                                SSHPanel.this.getLogger().severe(message);
                            }
                        }
                    }
                });
                File known = (File)this.m_FileChooserPanelKnownHosts.getCurrent();
                if (known.exists()) {
                    jsch.setKnownHosts(known.getAbsolutePath());
                }
                SSHAuthenticationType type = (SSHAuthenticationType)((Object)this.m_ComboBoxAuthenticationType.getSelectedItem());
                switch (type) {
                    case CREDENTIALS: {
                        this.m_Session = jsch.getSession(this.m_TextUser.getText(), this.m_TextRemote.getText(), ((Number)this.m_PortModel.getValue()).intValue());
                        this.m_Session.setPassword(new String(this.m_TextPassword.getPassword()));
                        this.m_Session.setConfig("StrictHostKeyChecking", "no");
                        break;
                    }
                    case PUBLIC_KEY: {
                        if (new String(this.m_TextKeyPassphrase.getPassword()).isEmpty()) {
                            jsch.addIdentity(((File)this.m_FileChooserPanelKey.getCurrent()).getAbsolutePath());
                        } else {
                            jsch.addIdentity(((File)this.m_FileChooserPanelKey.getCurrent()).getAbsolutePath(), new String(this.m_TextKeyPassphrase.getPassword()));
                        }
                        this.m_Session = jsch.getSession(this.m_TextUser.getText(), this.m_TextRemote.getText(), ((Number)this.m_PortModel.getValue()).intValue());
                        this.m_Session.setConfig("StrictHostKeyChecking", "no");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled authentication type: " + type);
                    }
                }
                this.m_Session.connect();
                this.updateButtons();
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        InputStream instr;
                        SSHPanel.this.m_Channel = null;
                        try {
                            SSHPanel.this.m_Channel = SSHPanel.this.m_Session.openChannel("shell");
                            ((ChannelShell)SSHPanel.this.m_Channel).setAgentForwarding(true);
                            ((ChannelShell)SSHPanel.this.m_Channel).setPty(false);
                            SSHPanel.this.m_Channel.connect();
                            instr = SSHPanel.this.m_Channel.getInputStream();
                        }
                        catch (Exception e) {
                            ConsolePanel.getSingleton().append((Object)this, "Exception while opening channel: ", (Throwable)e);
                            return;
                        }
                        try {
                            int ret_read;
                            byte[] buff = new byte[1024];
                            do {
                                if ((ret_read = instr.read(buff)) <= 0) continue;
                                SSHPanel.this.append(new String(buff, 0, ret_read), SSHPanel.this.m_AttributeSetRemote);
                                SSHPanel.this.updateButtons();
                            } while (ret_read >= 0);
                        }
                        catch (IOException e) {
                            ConsolePanel.getSingleton().append((Object)this, "Exception while reading socket: ", (Throwable)e);
                        }
                        SSHPanel.this.updateButtons();
                    }
                };
                new Thread(run).start();
            }
        }
        catch (Exception e) {
            this.append("Failed to " + msg + ": " + e, this.m_AttributeSetError);
            System.err.println("Failed to " + msg + ":");
            e.printStackTrace();
        }
    }

    protected void execCommand() {
        this.updateButtons();
        String cmd = this.m_TextCommand.getText();
        if (cmd.trim().length() == 0) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (cmd.equals("clear")) {
            this.m_TextCommand.setText("");
            this.m_CommandHistory.add(cmd);
            this.clear();
            this.updateButtons();
            return;
        }
        try {
            this.m_TextCommand.setText("");
            this.append(this.m_TextRemote.getText() + "> " + cmd, this.m_AttributeSetCmd);
            this.m_CommandHistory.add(cmd);
            DataOutputStream dos = new DataOutputStream(this.m_Channel.getOutputStream());
            dos.writeBytes(cmd + "\n");
            dos.flush();
            this.updateButtons();
        }
        catch (Exception e) {
            this.append("Failed to execute command " + cmd + ": " + e, this.m_AttributeSetError);
            System.err.println("Failed to execute command: " + cmd);
            e.printStackTrace();
        }
    }

    protected void updateButtons() {
        if (this.isConnected()) {
            this.m_ButtonConnection.setText("Disconnect");
        } else {
            this.m_ButtonConnection.setText("Connect");
        }
    }

    public void setRemote(String value) {
        this.m_TextRemote.setText(value);
    }

    public String getRemote() {
        return this.m_TextRemote.getText();
    }

    public void setPort(int value) {
        if (value > 0 && value <= 65536) {
            this.m_PortModel.setValue(value);
        } else {
            System.err.println("Invalid port number: " + value);
        }
    }

    public int getPort() {
        return ((Number)this.m_PortModel.getValue()).intValue();
    }

    public boolean isConnected() {
        return this.m_Session != null && this.m_Session.isConnected();
    }

    public synchronized adams.core.logging.Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = LoggingHelper.getLogger(((Object)((Object)this)).getClass());
            this.m_Logger.setLevel(Level.FINE);
        }
        return this.m_Logger;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public void clear() {
        this.m_TextOutput.setText("");
    }
}

