/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.BaseTextField;
import adams.gui.core.ConsolePanel;
import adams.gui.core.Fonts;
import adams.gui.core.ImageManager;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;

@MixedCopyright(copyright="Apache Software Foundation", author="Bruno D'Avanzo", license=License.APACHE2, url="http://commons.apache.org/proper/commons-net/examples/telnet/TelnetClientExample.java", note="Code adapted from TelnetClientExample")
public class TelnetPanel
extends BasePanel {
    private static final long serialVersionUID = 6647177121906710884L;
    protected BaseTextField m_TextRemote;
    protected SpinnerNumberModel m_PortModel;
    protected JSpinner m_SpinnerPort;
    protected BaseButton m_ButtonConnection;
    protected BaseTextAreaWithButtons m_TextOutput;
    protected BaseButton m_ButtonClear;
    protected BaseButton m_ButtonCopy;
    protected BaseTextField m_TextCommand;
    protected BaseButton m_ButtonCommand;
    protected TelnetClient m_Client;
    protected List<String> m_CommandHistory;
    protected int m_CommandIndex;

    protected void initialize() {
        super.initialize();
        this.m_Client = new TelnetClient();
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, false);
        EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);
        try {
            this.m_Client.addOptionHandler((TelnetOptionHandler)ttopt);
            this.m_Client.addOptionHandler((TelnetOptionHandler)echoopt);
            this.m_Client.addOptionHandler((TelnetOptionHandler)gaopt);
        }
        catch (Exception e) {
            System.err.println("Error registering telnet option handlers:");
            e.printStackTrace();
        }
        this.m_CommandIndex = 0;
        this.m_CommandHistory = new ArrayList<String>();
        this.m_CommandHistory.add("");
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        this.add(topPanel, "North");
        this.m_TextRemote = new BaseTextField(20);
        JLabel label = new JLabel("Remote");
        label.setDisplayedMnemonic('R');
        label.setLabelFor((Component)this.m_TextRemote);
        topPanel.add(label);
        topPanel.add((Component)this.m_TextRemote);
        this.m_PortModel = new SpinnerNumberModel();
        this.m_PortModel.setMinimum(Integer.valueOf(1));
        this.m_PortModel.setMaximum(Integer.valueOf(65536));
        this.m_PortModel.setStepSize(1);
        this.m_PortModel.setValue(23);
        this.m_SpinnerPort = new JSpinner(this.m_PortModel);
        label = new JLabel("Port");
        label.setDisplayedMnemonic('P');
        label.setLabelFor(this.m_SpinnerPort);
        topPanel.add(label);
        topPanel.add(this.m_SpinnerPort);
        this.m_ButtonConnection = new BaseButton();
        this.m_ButtonConnection.setMnemonic('n');
        this.m_ButtonConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelnetPanel.this.handleConnectionEvent();
            }
        });
        topPanel.add((Component)this.m_ButtonConnection);
        this.m_ButtonClear = new BaseButton("Clear", (Icon)ImageManager.getIcon((String)"new.gif"));
        this.m_ButtonClear.setMnemonic('l');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelnetPanel.this.m_TextOutput.setText("");
            }
        });
        this.m_ButtonCopy = new BaseButton("Copy", (Icon)ImageManager.getIcon((String)"copy.gif"));
        this.m_ButtonCopy.setMnemonic('C');
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TelnetPanel.this.m_TextOutput.getSelectedText().length() > 0) {
                    ClipboardHelper.copyToClipboard((String)TelnetPanel.this.m_TextOutput.getSelectedText());
                } else if (TelnetPanel.this.m_TextOutput.getText().length() > 0) {
                    ClipboardHelper.copyToClipboard((String)TelnetPanel.this.m_TextOutput.getText());
                }
            }
        });
        this.m_TextOutput = new BaseTextAreaWithButtons(10, 40);
        this.m_TextOutput.setTextFont(Fonts.getMonospacedFont());
        this.m_TextOutput.addToButtonsPanel((Component)this.m_ButtonClear);
        this.m_TextOutput.addToButtonsPanel((Component)this.m_ButtonCopy);
        this.add((Component)this.m_TextOutput, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(0));
        this.add(bottomPanel, "South");
        this.m_TextCommand = new BaseTextField(40);
        this.m_TextCommand.setFont(Fonts.getMonospacedFont());
        this.m_TextCommand.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                        TelnetPanel.this.execCommand();
                        break;
                    }
                    case 38: {
                        e.consume();
                        TelnetPanel.this.previousCommand();
                        break;
                    }
                    case 40: {
                        e.consume();
                        TelnetPanel.this.nextCommand();
                    }
                }
            }
        });
        label = new JLabel("Command");
        label.setDisplayedMnemonic('m');
        label.setLabelFor((Component)this.m_TextCommand);
        bottomPanel.add(label);
        bottomPanel.add((Component)this.m_TextCommand);
        this.m_ButtonCommand = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
        this.m_ButtonCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelnetPanel.this.execCommand();
            }
        });
        bottomPanel.add((Component)this.m_ButtonCommand);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    protected void previousCommand() {
        this.m_CommandIndex = this.m_CommandIndex > 0 ? --this.m_CommandIndex : this.m_CommandHistory.size() - 1;
        if (this.m_CommandIndex < 0) {
            this.m_CommandIndex = 0;
        }
        if (this.m_CommandIndex < this.m_CommandHistory.size()) {
            this.m_TextCommand.setText(this.m_CommandHistory.get(this.m_CommandIndex));
        }
    }

    protected void nextCommand() {
        this.m_CommandIndex = this.m_CommandIndex < this.m_CommandHistory.size() - 1 ? ++this.m_CommandIndex : 0;
        if (this.m_CommandIndex >= this.m_CommandHistory.size()) {
            this.m_CommandIndex = 0;
        }
        if (this.m_CommandIndex < this.m_CommandHistory.size()) {
            this.m_TextCommand.setText(this.m_CommandHistory.get(this.m_CommandIndex));
        }
    }

    protected void append(String msg) {
        ((BaseTextArea)this.m_TextOutput.getComponent()).append(msg + (msg.endsWith("\n") ? "" : "\n"));
    }

    protected boolean canConnect() {
        return this.m_TextRemote.getText().trim().length() > 0;
    }

    protected void handleConnectionEvent() {
        String msg = "??";
        try {
            if (this.m_Client.isConnected()) {
                msg = "disconnect";
                this.m_Client.disconnect();
                this.updateButtons();
            } else if (this.canConnect()) {
                msg = "connect";
                this.m_Client.connect(this.m_TextRemote.getText(), ((Number)this.m_PortModel.getValue()).intValue());
                this.updateButtons();
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        InputStream instr = TelnetPanel.this.m_Client.getInputStream();
                        try {
                            byte[] buff = new byte[1024];
                            int ret_read = 0;
                            do {
                                if ((ret_read = instr.read(buff)) <= 0) continue;
                                TelnetPanel.this.append(new String(buff, 0, ret_read));
                                TelnetPanel.this.updateButtons();
                            } while (ret_read >= 0);
                        }
                        catch (IOException e) {
                            ConsolePanel.getSingleton().append((Object)this, "Exception while reading socket:", (Throwable)e);
                        }
                        TelnetPanel.this.updateButtons();
                    }
                };
                new Thread(run).start();
            }
        }
        catch (Exception e) {
            this.append("Failed to " + msg + ": " + e);
            ConsolePanel.getSingleton().append((Object)this, "Failed to " + msg + ":", (Throwable)e);
        }
    }

    protected void execCommand() {
        this.updateButtons();
        String cmd = this.m_TextCommand.getText();
        if (cmd.trim().length() == 0) {
            return;
        }
        if (!this.m_Client.isConnected()) {
            return;
        }
        try {
            this.m_TextCommand.setText("");
            this.append(cmd);
            this.m_CommandHistory.add(cmd);
            this.m_Client.getOutputStream().write(new String(cmd + "\n").getBytes());
            this.m_Client.getOutputStream().flush();
            this.updateButtons();
        }
        catch (Exception e) {
            this.append("Failed to execute command " + cmd + ": " + e);
            ConsolePanel.getSingleton().append((Object)this, "Failed to execute command " + cmd + ": ", (Throwable)e);
        }
    }

    protected void updateButtons() {
        if (this.m_Client.isConnected()) {
            this.m_ButtonConnection.setText("Disconnect");
        } else {
            this.m_ButtonConnection.setText("Connect");
        }
    }

    public void setRemote(String value) {
        this.m_TextRemote.setText(value);
    }

    public String getRemote() {
        return this.m_TextRemote.getText();
    }

    public void setPort(int value) {
        if (value > 0 && value <= 65536) {
            this.m_PortModel.setValue(value);
        } else {
            System.err.println("Invalid port number: " + value);
        }
    }

    public int getPort() {
        return ((Number)this.m_PortModel.getValue()).intValue();
    }
}

