/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.multiobjectexport;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import adams.gui.visualization.multiobjectexport.AbstractMultiObjectExportWithPreferredExtensions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EmailExport
extends AbstractMultiObjectExportWithPreferredExtensions {
    private static final long serialVersionUID = 9186664398391763175L;
    protected String m_Prefix;
    protected EmailAddress m_Sender;
    protected EmailAddress[] m_Recipients;
    protected String m_Subject;
    protected BaseText m_Body;
    protected AbstractSendEmail m_SendEmail;

    public String globalInfo() {
        return "Sends the outputs via email.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
        this.m_OptionManager.add("sender", "sender", (Object)new EmailAddress(EmailHelper.getDefaultFromAddress()));
        this.m_OptionManager.add("recipient", "recipients", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("subject", "subject", (Object)"");
        this.m_OptionManager.add("body", "body", (Object)new BaseText());
        this.m_OptionManager.add("send-email", "sendEmail", (Object)EmailHelper.getDefaultSendEmail());
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The optional prefix for the files (<outputdir>/<prefix><name>.<ext>).";
    }

    public void setSender(EmailAddress value) {
        this.m_Sender = value;
        this.reset();
    }

    public EmailAddress getSender() {
        return this.m_Sender;
    }

    public String senderTipText() {
        return "The address of the sender.";
    }

    public void setRecipients(EmailAddress[] value) {
        this.m_Recipients = value;
        this.reset();
    }

    public EmailAddress[] getRecipients() {
        return this.m_Recipients;
    }

    public String recipientsTipText() {
        return "The addresses to the send the generated output to.";
    }

    public void setSubject(String value) {
        this.m_Subject = value;
        this.reset();
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public String subjectTipText() {
        return "The subject for email.";
    }

    public void setBody(BaseText value) {
        this.m_Body = value;
        this.reset();
    }

    public BaseText getBody() {
        return this.m_Body;
    }

    public String bodyTipText() {
        return "The body of email.";
    }

    public void setSendEmail(AbstractSendEmail value) {
        this.m_SendEmail = value;
        this.reset();
    }

    public AbstractSendEmail getSendEmail() {
        return this.m_SendEmail;
    }

    public String sendEmailTipText() {
        return "The engine for sending the emails.";
    }

    protected String doExport(String[] names, Object[] objects) {
        int i;
        for (i = 0; i < names.length; ++i) {
            names[i] = FileUtils.createFilename((String)(this.m_Prefix + names[i]), (String)"");
        }
        names = this.disambiguateNames(names);
        MessageCollection errors = new MessageCollection();
        File outputDir = TempUtils.createTempFile((String)"emailexport", (String)"");
        if (!outputDir.mkdirs()) {
            errors.add("Failed to create temporary output directory: " + outputDir);
        }
        ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
        if (errors.isEmpty()) {
            for (i = 0; i < names.length; ++i) {
                List exporters = this.determineExporters(names[i], objects[i], errors);
                for (AbstractObjectExporter exporter : exporters) {
                    String ext = this.determineExtension(exporter);
                    PlaceholderFile file = new PlaceholderFile(outputDir.getAbsolutePath() + File.separator + names[i] + "." + ext);
                    String msg = exporter.export(objects[i], (File)file);
                    if (msg != null) {
                        errors.add("Failed to find export '" + names[i] + "'/" + Utils.classToString((Object)objects[i]) + "\n" + msg);
                        continue;
                    }
                    files.add(file);
                }
            }
        }
        if (errors.isEmpty()) {
            Email email = new Email(this.m_Sender, this.m_Recipients, this.m_Subject, this.m_Body.getValue(), files.toArray(new File[files.size()]));
            try {
                if (this.m_SendEmail.requiresSmtpSessionInitialization()) {
                    this.m_SendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword(), EmailHelper.getSmtpProtocols());
                }
                if (!this.m_SendEmail.sendMail(email)) {
                    errors.add("Failed to send email!");
                }
            }
            catch (Exception e) {
                errors.add("Failed to send email!", (Throwable)e);
            }
        }
        if (outputDir.exists()) {
            FileUtils.delete((File)outputDir);
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toString();
    }
}

