/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.MultiAttemptWithWaitSupporter;
import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.base.BaseHostname;
import adams.core.base.HostnameUpdateSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.core.net.InternetHelper;
import adams.core.net.Scp;
import adams.core.option.OptionHandler;
import adams.event.JobCompleteListener;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.SSHConnection;
import adams.multiprocess.AbstractMetaJobRunner;
import adams.multiprocess.Job;
import adams.multiprocess.JobResult;
import adams.multiprocess.JobRunner;
import adams.multiprocess.LocalJobRunner;
import java.io.File;

public class ScpJobRunner
extends AbstractMetaJobRunner
implements MultiAttemptWithWaitSupporter,
HostnameUpdateSupporter {
    private static final long serialVersionUID = 6656064128031953130L;
    protected PlaceholderFile m_RemoteFile;
    protected BaseHostname m_LocalHost;
    protected PlaceholderFile m_LocalFile;
    protected int m_MaxWait;
    protected int m_NumAttempts;
    protected int m_AttemptInterval;
    protected boolean m_AllowLocalExecution;
    protected transient SSHConnection m_Connection;
    protected BaseHostname m_ActualHost;
    protected boolean m_RunLocally;
    protected long m_StartTime;

    public String globalInfo() {
        return "Wraps another jobrunner and serializes it, scp's it to the specified remote file and then waits for the specified import file (containing the serialized, executed jobs) to appear.\nRequires a " + SSHConnection.class.getName() + " standalone for defining the SSH connection.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-file", "remoteFile", (Object)this.getDefaultRemoteFile());
        this.m_OptionManager.add("local-host", "localHost", (Object)new BaseHostname(":22"));
        this.m_OptionManager.add("local-file", "localFile", (Object)this.getDefaultLocalFile());
        this.m_OptionManager.add("max-wait", "maxWait", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-attempts", "numAttempts", (Object)10, (Number)1, null);
        this.m_OptionManager.add("attempt-interval", "attemptInterval", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("allow-local-execution", "allowLocalExecution", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Connection = null;
        this.m_ActualHost = null;
    }

    protected PlaceholderFile getDefaultRemoteFile() {
        return new PlaceholderFile(".");
    }

    public void setRemoteFile(PlaceholderFile value) {
        this.m_RemoteFile = value;
        this.reset();
    }

    public PlaceholderFile getRemoteFile() {
        return this.m_RemoteFile;
    }

    public String remoteFileTipText() {
        return "The remote file for the un-executed jobs.";
    }

    public void setLocalHost(BaseHostname value) {
        this.m_LocalHost = value;
        this.reset();
    }

    public BaseHostname getLocalHost() {
        return this.m_LocalHost;
    }

    public String localHostTipText() {
        return "The host (name/IP address:port) that the remote host will connect to when sending back the executed jobs; leave empty to use auto-detection.";
    }

    protected PlaceholderFile getDefaultLocalFile() {
        return new PlaceholderFile(".");
    }

    public void setLocalFile(PlaceholderFile value) {
        this.m_LocalFile = value;
        this.reset();
    }

    public PlaceholderFile getLocalFile() {
        return this.m_LocalFile;
    }

    public String localFileTipText() {
        return "The file to deserialize the executed jobs from.";
    }

    public void setMaxWait(int value) {
        if (this.getOptionManager().isValid("maxWait", (Number)value)) {
            this.m_MaxWait = value;
            this.reset();
        }
    }

    public int getMaxWait() {
        return this.m_MaxWait;
    }

    public String maxWaitTipText() {
        return "The maximum time to wait in milli-seconds before giving up on remote jobs; -1 for indefinite.";
    }

    public void setNumAttempts(int value) {
        if (this.getOptionManager().isValid("numAttempts", (Number)value)) {
            this.m_NumAttempts = value;
            this.reset();
        }
    }

    public int getNumAttempts() {
        return this.m_NumAttempts;
    }

    public String numAttemptsTipText() {
        return "The maximum number of intervals to wait.";
    }

    public void setAttemptInterval(int value) {
        if (this.getOptionManager().isValid("attemptInterval", (Number)value)) {
            this.m_AttemptInterval = value;
            this.reset();
        }
    }

    public int getAttemptInterval() {
        return this.m_AttemptInterval;
    }

    public String attemptIntervalTipText() {
        return "The interval in milli-seconds to wait before continuing with the execution.";
    }

    public void setAllowLocalExecution(boolean value) {
        this.m_AllowLocalExecution = value;
        this.reset();
    }

    public boolean getAllowLocalExecution() {
        return this.m_AllowLocalExecution;
    }

    public String allowLocalExecutionTipText() {
        return "If enabled, executes the jobs locally in case the SCP operation fails.";
    }

    @Override
    public void updateHostname(BaseHostname host) {
        this.m_ActualHost = host;
    }

    protected boolean getTransferJobCompleteListeners() {
        return false;
    }

    protected JobRunner newActualJobRunner() {
        RemoteJobRunner result = new RemoteJobRunner();
        if (this.m_LocalHost.hostnameValue().isEmpty()) {
            result.setHost(new BaseHostname(InternetHelper.getHostnameFromNetworkInterface() + ":" + this.m_LocalHost.portValue(22)));
        } else {
            result.setHost(this.getLocalHost());
        }
        result.setRemoteFile(this.getLocalFile().getAbsoluteFile());
        result.setJobRunner(this.getJobRunner());
        result.setLoggingLevel(this.getLoggingLevel());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Remote jobrunner: " + result.toCommandLine());
        }
        return result;
    }

    protected String preStart() {
        String result = super.preStart();
        if (result != null) {
            return result;
        }
        if (this.m_Connection == null) {
            if (this.getFlowContext() == null) {
                return "No flow context set, aborting!";
            }
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((Actor)this.getFlowContext(), SSHConnection.class);
            if (this.m_Connection == null) {
                return "No " + SSHConnection.class.getName() + " actor found, aborting!";
            }
        }
        return null;
    }

    protected String doStart() {
        int port;
        String host;
        this.m_RunLocally = false;
        if (this.m_ActualHost != null) {
            host = this.m_ActualHost.hostnameValue();
            port = this.m_ActualHost.portValue(22);
        } else {
            host = null;
            port = -1;
        }
        String actualHost = host == null ? this.m_Connection.getHost() : host;
        int actualPort = host == null ? this.m_Connection.getPort() : port;
        File tmpFile = TempUtils.createTempFile((String)("adams-jobs-" + actualHost + "-"), (String)".ser");
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Serializing jobs to " + tmpFile);
            }
            SerializationHelper.write((String)tmpFile.getAbsolutePath(), (Object)this.m_ActualJobRunner);
        }
        catch (Exception e) {
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to serialize jobrunner to: " + this.m_RemoteFile), (Throwable)e);
        }
        this.m_StartTime = System.currentTimeMillis();
        try {
            String msg;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Scp'ing jobs to " + actualHost + ":" + actualPort + this.m_RemoteFile.getAbsolutePath());
            }
            if ((msg = Scp.copyTo((LoggingObject)this, this.m_Connection, host, port, tmpFile, this.m_RemoteFile.getAbsolutePath())) != null) {
                this.getLogger().severe("Failed to copy serialized jobrunner to remote host " + actualHost + ":" + actualPort + ": " + msg);
            }
            tmpFile.delete();
        }
        catch (Exception e) {
            tmpFile.delete();
            if (!this.m_AllowLocalExecution) {
                return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to copy serialized jobrunner to remote host " + actualHost + ":" + actualPort), (Throwable)e);
            }
            LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to copy serialized jobrunner to remote host " + actualHost + ":" + actualPort), (Throwable)e);
            this.m_RunLocally = true;
        }
        if (this.m_RunLocally) {
            this.getLogger().info("Executing jobs locally");
            this.m_ActualJobRunner = new LocalJobRunner();
            for (int i = 0; i < this.m_Jobs.size(); ++i) {
                this.m_ActualJobRunner.add((Job)this.m_Jobs.get(i));
            }
            for (JobCompleteListener l : this.m_JobCompleteListeners) {
                this.m_ActualJobRunner.addJobCompleteListener(l);
            }
            this.m_ActualJobRunner.start();
            this.m_ActualJobRunner.stop();
        }
        return null;
    }

    protected String doStop() {
        if (!this.m_RunLocally) {
            int count;
            while (this.isRunning() || this.isPaused()) {
                if (!this.isPaused()) {
                    if (this.m_LocalFile.exists()) break;
                    if (this.m_MaxWait > -1 && System.currentTimeMillis() >= this.m_StartTime + (long)this.m_MaxWait) {
                        this.m_Running = false;
                        return "Max wait reached (" + this.m_MaxWait + "msec)";
                    }
                }
                Utils.wait((LoggingSupporter)this, (int)100, (int)100);
            }
            if (this.isRunning()) {
                for (count = 0; count < this.m_NumAttempts && this.isRunning() && FileUtils.isOpen((File)this.m_LocalFile); ++count) {
                    Utils.wait((LoggingSupporter)this, (int)this.m_AttemptInterval, (int)Math.min(100, this.m_AttemptInterval));
                }
            }
            if (this.isRunning()) {
                boolean inUse = FileUtils.isOpen((File)this.m_LocalFile);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("count=" + count + ", inUse=" + inUse + ", file=" + this.m_LocalFile);
                }
                if (count == this.m_NumAttempts && inUse) {
                    return "File '" + this.m_LocalFile + "' is still in use after " + this.m_NumAttempts + " * " + this.m_AttemptInterval + "msec!";
                }
                try {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Reading jobs from " + this.m_LocalFile);
                    }
                    this.m_ActualJobRunner = (JobRunner)SerializationHelper.read((String)this.m_LocalFile.getAbsolutePath());
                }
                catch (Exception e) {
                    this.m_ActualJobRunner = null;
                    return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to deserialize jobrunner form: " + this.m_LocalFile), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String doTerminate(boolean wait) {
        if (this.m_RunLocally && this.m_ActualJobRunner != null) {
            this.m_ActualJobRunner.terminate(wait);
        }
        return null;
    }

    public void complete(Job j, JobResult jr) {
        this.getLogger().warning("complete(Job,JobResult) - ignored");
    }

    protected static class RemoteJobRunner
    extends AbstractMetaJobRunner {
        private static final long serialVersionUID = 1416016602112933887L;
        protected BaseHostname m_Host;
        protected File m_RemoteFile;
        protected transient SSHConnection m_Connection;

        protected RemoteJobRunner() {
        }

        public String globalInfo() {
            return "Performs the actual execution of the jobs on the remote machine and sends the results back.";
        }

        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("host", "host", (Object)new BaseHostname("remote:22"));
            this.m_OptionManager.add("remote-file", "remoteFile", (Object)this.getDefaultRemoteFile());
        }

        protected void initialize() {
            super.initialize();
            this.m_Connection = null;
        }

        public void setHost(BaseHostname value) {
            this.m_Host = value;
            this.reset();
        }

        public BaseHostname getHost() {
            return this.m_Host;
        }

        public String hostTipText() {
            return "The host (name/IP address:port) to connect to.";
        }

        protected File getDefaultRemoteFile() {
            return new File(".");
        }

        public void setRemoteFile(File value) {
            this.m_RemoteFile = value;
            this.reset();
        }

        public File getRemoteFile() {
            return this.m_RemoteFile;
        }

        public String remoteFileTipText() {
            return "The remote file for the executed jobs on the host that sent the jobs.";
        }

        public String getQuickInfo() {
            Object result = super.getQuickInfo();
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)this.m_Host, (String)", host: ");
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"remoteFile", (Object)this.m_RemoteFile, (String)", remote file: ");
            return result;
        }

        protected String preStart() {
            String result = super.preStart();
            if (result != null) {
                return result;
            }
            if (this.m_Connection == null) {
                if (this.getFlowContext() == null) {
                    return "No flow context set, aborting!";
                }
                this.m_Connection = (SSHConnection)ActorUtils.findClosestType((Actor)this.getFlowContext(), SSHConnection.class);
                if (this.m_Connection == null) {
                    return "No " + SSHConnection.class.getName() + " actor found, aborting!";
                }
            }
            return null;
        }

        protected String doStart() {
            this.m_ActualJobRunner.start();
            this.m_ActualJobRunner.stop();
            return null;
        }

        protected String doStop() {
            this.m_ActualJobRunner.stop();
            File tmpFile = TempUtils.createTempFile((String)("adams-jobs-" + this.m_Host + "-"), (String)".ser");
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Serializing jobs to " + tmpFile);
            }
            try {
                SerializationHelper.write((String)tmpFile.getAbsolutePath(), (Object)this.m_ActualJobRunner);
            }
            catch (Exception e) {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to serialize jobrunner to: " + this.m_RemoteFile), (Throwable)e);
            }
            try {
                String msg;
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Scp'ing jobs to " + this.m_Host + this.m_RemoteFile.getAbsolutePath());
                }
                if ((msg = Scp.copyTo((LoggingObject)this, this.m_Connection, this.m_Host.hostnameValue(), this.m_Host.portValue(22), tmpFile, this.m_RemoteFile.getAbsolutePath())) != null) {
                    return "Failed to copy serialized jobrunner to original host " + this.m_Host + ": " + msg;
                }
                tmpFile.delete();
            }
            catch (Exception e) {
                tmpFile.delete();
                return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to copy serialized jobrunner to original host " + this.m_Host), (Throwable)e);
            }
            return null;
        }

        protected String doTerminate(boolean wait) {
            this.m_ActualJobRunner.terminate(wait);
            return null;
        }

        public void complete(Job j, JobResult jr) {
            this.getLogger().warning("complete(Job,JobResult) - ignored");
        }
    }
}

