/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.visualization.nlp.StanfordTree;
import edu.stanford.nlp.trees.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;

public class StanfordParseTreeDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 680299970232233254L;
    protected StanfordTree m_Tree;
    protected boolean m_Expand;

    public String globalInfo() {
        return "Displays a Stanford parse tree.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expand", "expand", (Object)false);
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"expand", (boolean)this.m_Expand, (String)"expand", (String)", ");
        return result;
    }

    public void setExpand(boolean value) {
        this.m_Expand = value;
        this.reset();
    }

    public boolean getExpand() {
        return this.m_Expand;
    }

    public String expandTipText() {
        return "If enabled, the tree gets fully expanded.";
    }

    public Class[] accepts() {
        return new Class[]{Tree.class};
    }

    protected void display(Token token) {
        this.m_Tree.setTree((Tree)token.getPayload());
        if (this.m_Expand) {
            this.m_Tree.expandAll();
        }
    }

    public void clearPanel() {
        if (this.m_Tree != null) {
            this.m_Tree.setTree(null);
        }
    }

    protected BasePanel newPanel() {
        this.m_Tree = new StanfordTree();
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        result.add((Component)new BaseScrollPane((Component)((Object)this.m_Tree)), (Object)"Center");
        return result;
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("Text file", "txt");
    }

    public String supplyText() {
        if (this.m_Tree != null) {
            return this.m_Tree.getTree().toString();
        }
        return null;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected StanfordTree m_Tree;

            protected void initGUI() {
                super.initGUI();
                this.m_Tree = new StanfordTree();
                this.add((Component)new BaseScrollPane((Component)((Object)this.m_Tree)), "Center");
            }

            public void display(Token token) {
                this.m_Tree.setTree((Tree)token.getPayload());
                if (StanfordParseTreeDisplay.this.m_Expand) {
                    this.m_Tree.expandAll();
                }
            }

            public void clearPanel() {
                this.m_Tree.setTree(null);
            }

            public void cleanUp() {
                this.m_Tree.setTree(null);
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("Text file", "txt");
            }

            public String supplyText() {
                if (this.m_Tree != null) {
                    return this.m_Tree.getTree().toString();
                }
                return null;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

