/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.core.io.CoNLLHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.AbstractArrayProvider;
import java.io.File;
import java.util.List;

public class CoNLLFileReader
extends AbstractArrayProvider {
    private static final long serialVersionUID = 5212193701591968782L;

    public String globalInfo() {
        return "Reads files in CoNLL format.\n\nFor more information see:\nhttp://ilk.uvt.nl/conll/#dataformat";
    }

    public String outputArrayTipText() {
        return "If enabled, an array of spreadsheets is output instead of one by one.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected Class getItemClass() {
        return SpreadSheet.class;
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = null;
        if (this.m_InputToken.getPayload() instanceof String) {
            file = new PlaceholderFile((String)this.m_InputToken.getPayload());
        } else if (this.m_InputToken.getPayload() instanceof File) {
            file = new PlaceholderFile((File)this.m_InputToken.getPayload());
        } else {
            result = "Unhandled input type: " + Utils.classToString(this.m_InputToken.getPayload().getClass());
        }
        if (result == null) {
            if (!file.exists()) {
                result = "File does not exist: " + file;
            } else if (file.isDirectory()) {
                result = "File points to a directory: " + file;
            }
        }
        if (result == null) {
            this.m_Queue.clear();
            List<String> lines = FileUtils.loadFromFile((File)file);
            lines = CoNLLHelper.group(lines);
            for (String content : lines) {
                this.m_Queue.add(CoNLLHelper.parse(content));
            }
        }
        return result;
    }
}

