/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import cmu.arktweetnlp.Tagger;
import java.util.List;

public class TweetNLPTagger
extends AbstractTransformer {
    private static final long serialVersionUID = -5173287647181703988L;
    protected PlaceholderFile m_Model;
    protected transient Tagger m_Tagger;

    public String globalInfo() {
        return "Applies the TweetNLP tagger to the incoming string.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model", "model", (Object)new PlaceholderFile("."));
    }

    protected void reset() {
        super.reset();
        this.m_Tagger = null;
    }

    public void setModel(PlaceholderFile value) {
        this.m_Model = value;
        this.reset();
    }

    public PlaceholderFile getModel() {
        return this.m_Model;
    }

    public String modelTipText() {
        return "The model file to load and use.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Tagger == null) {
            this.m_Tagger = new Tagger();
            try {
                this.m_Tagger.loadModel(this.m_Model.getAbsolutePath());
            }
            catch (Exception e) {
                result = this.handleException("Failed to load tagger model: " + this.m_Model, e);
            }
        }
        if (result == null) {
            List tokens = this.m_Tagger.tokenizeAndTag((String)this.m_InputToken.getPayload());
            SpreadSheet sheet = new SpreadSheet();
            sheet.setName(this.getName());
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("S").setContentAsString("Token");
            row.addCell("T").setContentAsString("Tag");
            for (Tagger.TaggedToken token : tokens) {
                row = sheet.addRow();
                row.addCell("S").setContentAsString(token.token);
                row.addCell("T").setContentAsString(token.tag);
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

