/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers.cleaners;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import weka.core.WekaOptionUtils;
import weka.core.tokenizers.cleaners.AbstractTokenCleaner;

public class RegExp
extends AbstractTokenCleaner {
    private static final long serialVersionUID = -1815343837519097597L;
    public static final String FIND = "find";
    public static final String REPLACE = "replace";
    protected String m_Find = this.getDefaultFind();
    protected String m_Replace = this.getDefaultReplace();
    protected transient Pattern m_Pattern = null;

    public String globalInfo() {
        return "Cleans tokens based on regular expressions, i.e., if token matches regexp, it gets replaced with the specified expression.\n\nFor more information see:\nhttp://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, (String)this.findTipText(), (String)("" + this.getDefaultFind()), (String)FIND);
        WekaOptionUtils.addOption(result, (String)this.replaceTipText(), (String)("" + this.getDefaultReplace()), (String)REPLACE);
        WekaOptionUtils.add(result, (Enumeration)super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setFind(WekaOptionUtils.parse((String[])options, (String)FIND, (String)this.getDefaultFind()));
        this.setReplace(WekaOptionUtils.parse((String[])options, (String)REPLACE, (String)this.getDefaultReplace()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList result = new ArrayList();
        WekaOptionUtils.add(result, (String)FIND, (String)this.getFind());
        WekaOptionUtils.add(result, (String)REPLACE, (String)this.getReplace());
        WekaOptionUtils.add(result, (String[])super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected void reset() {
        super.reset();
        this.m_Pattern = null;
    }

    protected String getDefaultFind() {
        return ".*";
    }

    public void setFind(String value) {
        this.m_Find = value;
        this.reset();
    }

    public String getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The regular expression to use for finding tokens to clean.";
    }

    protected String getDefaultReplace() {
        return "";
    }

    public void setReplace(String value) {
        this.m_Replace = value;
        this.reset();
    }

    public String getReplace() {
        return this.m_Replace;
    }

    public String replaceTipText() {
        return "The expression to use for replacing matching tokens with; empty string results in removing a matching token completely.";
    }

    public String clean(String token) {
        if (this.m_Pattern == null) {
            this.m_Pattern = Pattern.compile(this.m_Find);
        }
        if (this.m_Pattern.matcher(token).matches()) {
            if (this.m_Replace.isEmpty()) {
                return null;
            }
            return token.replaceAll(this.m_Find, this.m_Replace);
        }
        return token;
    }
}

