/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import edu.stanford.nlp.trees.Tree;

public class StanfordParseTreeToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -309330039614297403L;

    public String globalInfo() {
        return "Turns the leaves of a Stanford parse tree into a spreadsheet.";
    }

    public Class accepts() {
        return Tree.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected void traverseTree(SpreadSheet sheet, Tree parentTree, String[] path) {
        for (int i = 0; i < parentTree.children().length; ++i) {
            Tree childTree = parentTree.children()[i];
            Object[] newPath = new String[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            newPath[newPath.length - 1] = parentTree.label().value();
            if (childTree.isLeaf()) {
                DataRow row = sheet.addRow();
                row.addCell("W").setContent(childTree.label().value());
                row.addCell("T").setContent(parentTree.label().value());
                row.addCell("P").setContent(Utils.flatten((Object[])newPath, (String)"."));
                row.addCell("S").setContent(Double.valueOf(parentTree.score()));
            }
            this.traverseTree(sheet, childTree, (String[])newPath);
        }
    }

    protected Object doConvert() throws Exception {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("W").setContent("Word");
        row.addCell("T").setContent("Type");
        row.addCell("P").setContent("Path");
        row.addCell("S").setContent("Score");
        Tree tree = (Tree)this.m_Input;
        this.traverseTree((SpreadSheet)result, tree, new String[0]);
        return result;
    }
}

