/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class EditDistance
extends AbstractTransformer {
    private static final long serialVersionUID = 8672966207037874116L;
    protected String m_Base;
    protected boolean m_AllowTransposition;
    protected transient com.aliasi.spell.EditDistance m_Distance;

    public String globalInfo() {
        return "Computes the edit distance between the supplied base string and the one passing through, outputting the distance.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("base", "base", (Object)"");
        this.m_OptionManager.add("allow-transposition", "allowTransposition", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Distance = null;
    }

    public void setBase(String value) {
        this.m_Base = value;
        this.reset();
    }

    public String getBase() {
        return this.m_Base;
    }

    public String baseTipText() {
        return "The base string to compare against.";
    }

    public void setAllowTransposition(boolean value) {
        this.m_AllowTransposition = value;
        this.reset();
    }

    public boolean getAllowTransposition() {
        return this.m_AllowTransposition;
    }

    public String allowTranspositionTipText() {
        return "If enabled, transposition is allowed.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"base", (Object)(this.m_Base.isEmpty() ? "-none-" : this.m_Base), (String)"compare with: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"allowTransposition", (Object)(this.m_AllowTransposition ? "transposition allowed" : "no transposition"), (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{Double.class};
    }

    protected String doExecute() {
        if (this.m_Distance == null) {
            this.m_Distance = new com.aliasi.spell.EditDistance(this.m_AllowTransposition);
        }
        String other = (String)this.m_InputToken.getPayload();
        double distance = this.m_Distance.distance((CharSequence)this.m_Base, (CharSequence)other);
        this.m_OutputToken = new Token((Object)distance);
        return null;
    }
}

